package cn.gtmap.secondaryMarket.common.constants;

/**
 * 共通常量类
 * @author zsj
 * @version v1.0, 2018/5/3
 */
public class CommonConst {

	/**
	 * 操作标识
	 * 
	 * @version 1.0
	 * @author KitChan
	 */
	public static class OperationFlg {
		/** 成功标识 */
		public static final String SUCCESS = "success";

		/** 失败标识 */
		public static final String FAILURE = "failure";
		
		/** 记录已经存在标识 */
		public static final String EXITS = "exits";

		/** 警告标识 */
		public static final String ALARM = "alarm";
		
		/** 导入成功标识 */
		public static final String IMPORTSUCCESS = "importSuccess";
		
		/** 导入失败标识 */
		public static final String IMPORTFAILURE = "importFailure";
		
		/** 上传文件标识 */
		public static final String UPLOADFILE = "uploadFile";
	}

	/**
	 * 数值的定义类
	 * 
	 * @version 1.0
	 * @author kevinli
	 */
	public static class NumberValue {

		/** 数值:0. */
		public static final int NUM_0 = 0;

		/** 数值:1. */
		public static final int NUM_1 = 1;

		/** 数值:2. */
		public static final int NUM_2 = 2;

		/** 数值:3. */
		public static final int NUM_3 = 3;

		/** 数值:4. */
		public static final int NUM_4 = 4;

		/** 数值:5. */
		public static final int NUM_5 = 5;

		/** 数值:6. */
		public static final int NUM_6 = 6;

		/** 数值:7. */
		public static final int NUM_7 = 7;

		/** 数值:8. */
		public static final int NUM_8 = 8;

		/** 数值:9. */
		public static final int NUM_9 = 9;

		/** 数值:10. */
		public static final int NUM_10 = 10;

		/** 数值:11. */
		public static final int NUM_11 = 11;

		/** 数值:12. */
		public static final int NUM_12 = 12;

		/** 数值:13. */
		public static final int NUM_13 = 13;

		/** 数值:14. */
		public static final int NUM_14 = 14;

		/** 数值:15. */
		public static final int NUM_15 = 15;

		/** 数值:16. */
		public static final int NUM_16 = 16;

		/** 数值:17. */
		public static final int NUM_17 = 17;

		/** 数值:20. */
		public static final int NUM_20 = 20;

		/** 数值:28. */
		public static final int NUM_28 = 28;
		
		/** 数值:10000001. */
		public static final int NUM_10000001 = 10000001;
		
		/** 数值:10000002. */
		public static final int NUM_10000002 = 10000002;
		
		/** 数值:10000003. */
		public static final int NUM_10000003 = 10000003;
		
		/** 数值:10000004. */
		public static final int NUM_10000004 = 10000004;
		
		/** 数值:10000005. */
		public static final int NUM_10000005 = 10000005;
		
		/** 数值:10000006. */
		public static final int NUM_10000006 = 10000006;
		
		/** 数值:10000007. */
		public static final int NUM_10000007 = 10000007;
		
		/** 数值:10000008. */
		public static final int NUM_10000008 = 10000008;
		
		/** 数值:10000009. */
		public static final int NUM_10000009 = 10000009;
		
		/** 数值: -1 */
		public static final Integer NUM_F1 = -1;

	}

	/**
	 * 文字的定义类
	 * 
	 * @version 1.0
	 * @author kevinli
	 */
	public static class CharValue {

		/** 文字:全角空格. */
		public static final char WIDE_SPACE = '　';

		/** 文字:-. */
		public static final char HYPHEN = '-';

		/** 文字:. */
		public static final char PERIOD = '.';

		/** 文字：半角空格. */
		public static final char HALF_SPACE = ' ';

		/** 文字：半角ゼロ. */
		public static final char HALF_ZERO = '0';

		/** 文字：半角コンマ. */
		public static final char COMMA = ',';

		/** 文字：TAB. */
		public static final char TAB = '\t';

		/** 文字：クウォウト. */
		public static final char QUOTE = '"';

		/** 文字：\n. */
		public static final char NEW_LINE = '\n';
	}

	/**
	 * 文字列的定义类
	 * 
	 * @version 1.0
	 * @author kevinli
	 */
	public static class StringValue {

		/** 文字列:全角空格. */
		public static final String WIDE_SPACE = "　";

		/** 文字列:半角-. */
		public static final String HALF_HYPHEN = "-";

		/** 符号:半角+. */
		public static final String HALF_PLUS = "+";

		/** 符号：分号. */
		public static final String SEMICOLON = ";";

		/** 文字列:. */
		public static final String PERIOD = ".";

		/** 文字列：空白文字. */
		public static final String EMPTY = "";

		/** 文字列：半角空格. */
		public static final String HALF_SPACE = " ";

		/** { */
		public static final String LEFTMARK = "{";

		/** } */
		public static final String RIGHTMARK = "}";

		/** 文字列：路径的/. */
		public static final String SEPERTOR = System
				.getProperty("file.separator");

		/** 文字列：半角コンマ. */
		public static final String COMMA = ",";

		/** 文字列：TAB. */
		public static final String TAB = "\t";

		/** 文字：クウォウト. */
		public static final String QUOTE = "\"";

		/** 文字：\n. */
		public static final String NEW_LINE = "\n";

		/** 文字列：0. */
		public static final String STR_0 = "0";

		/** 文字列：00. */
		public static final String STR_00 = "00";

		/** 文字列：000. */
		public static final String STR_000 = "000";

		/** 文字列：0000. */
		public static final String STR_0000 = "0000";

		/** 文字列：01. */
		public static final String STR_01 = "01";
	
		/** 文字列：1. */
		public static final String STR_1 = "1";

		/** 文字列：2. */
		public static final String STR_2 = "2";

		/** 文字列：3. */
		public static final String STR_3 = "3";

		/** 文字列：4. */
		public static final String STR_4 = "4";

		/** 文字列：5. */
		public static final String STR_5 = "5";

		/** 文字列：6. */
		public static final String STR_6 = "6";

		/** 文字列：7. */
		public static final String STR_7 = "7";

		/** 文字列：8. */
		public static final String STR_8 = "8";

		/** 文字列：9. */
		public static final String STR_9 = "9";

		/** 文字列：10. */
		public static final String STR_10 = "10";

		/** 文字列：11. */
		public static final String STR_11 = "11";

		/** 文字列：12. */
		public static final String STR_12 = "12";

		/** 文字列：13. */
		public static final String STR_13 = "13";

		/** 文字列：14. */
		public static final String STR_14 = "14";

		/** 文字列：15. */
		public static final String STR_15 = "15";

		/** 文字列：16. */
		public static final String STR_16 = "16";

		/** 文字列：17. */
		public static final String STR_17 = "17";

		/** 文字列：18. */
		public static final String STR_18 = "18";

		/** 文字列：19. */
		public static final String STR_19 = "19";

		/** 文字列：20. */
		public static final String STR_20 = "20";

		/** 文字列：31. */
		public static final String STR_31 = "31";

		/** 文字列：32. */
		public static final String STR_32 = "32";

		/** 文字列：33. */
		public static final String STR_33 = "33";

		/** 文字列：52. */
		public static final String STR_52 = "52";
		
		/** 文字列：001. */
		public static final String STR_001 = "001";
		
		/** 文字列：0700. */
		public static final String STR_0700 = "0700";

		/** 文字列：1200. */
		public static final String STR_1200 = "1200";

		/** 文字列：1600. */
		public static final String STR_1600 = "1600";

		/** 文字列：1800. */
		public static final String STR_1800 = "1800";

		/** 文字列：2100. */
		public static final String STR_2100 = "2100";

		/** 文字列：0001. */
		public static final String STR_0001 = "0001";

		/** 文字列：* */
		public static final String START_1 = "*";

		/** 文字列：** */
		public static final String START_2 = "**";

		/** 文字列：*** */
		public static final String START_3 = "***";

		/** 文字列：**** */
		public static final String START_4 = "****";

		/** 文字列：**** */
		public static final String KETA_MAX_STRING = "########";

		/** AC. */
		public static final String CODE_NO_AC = "AC";
		
		/** Y */
		public static final String CODE_NO_Y = "Y";

		/** 文字列：1半角空格. */
		public static final String H_SPACE_1 = " ";

		/** 文字列：2半角空格. */
		public static final String H_SPACE_2 = "  ";

		/** 文字列：3半角空格. */
		public static final String H_SPACE_3 = "   ";

		/** 文字列：4半角空格. */
		public static final String H_SPACE_4 = "    ";

		/** 文字列：0. */
		public static final String ZERO_1 = "0";

		/** 文字列：00. */
		public static final String ZERO_2 = "00";

		/** 文字列：000. */
		public static final String ZERO_3 = "000";

		/** 文字列：0000. */
		public static final String ZERO_4 = "0000";

		/** 文字列：00000. */
		public static final String ZERO_5 = "00000";

		/** 文字列：000000. */
		public static final String ZERO_6 = "000000";

		/** 文字列：0000000. */
		public static final String ZERO_7 = "0000000";

		/** 文字列：00000000. */
		public static final String ZERO_8 = "00000000";

		/** 文字列：00000000. */
		public static final String ZERO_9 = "000000000";

		/** 文字列：0000000000. */
		public static final String ZERO_10 = "0000000000";

		/** 文字列::. */
		public static final String COLON = ":";

		/** 文字列:"（". */
		public static final String HALF_LEFT_PARENTHESIS = "(";

		/** 文字列:"）". */
		public static final String HALF_RIGHT_PARENTHESIS = ")";

		/** 改行CODE */
		public static final String LF_CODE = "\n";

		/** 百分比 **/
		public static final String PERCENT = "%";

		/** ～ */
		public static final String RMONTHS = "～";

		/** 文字列:半角/ */
		public static final String HALF_LEFT_SLASH = "/";

		/** ' */
		public static final String SINGLE = "'";

		/** RESULT */
		public static final String RESULT = "result";

		/** ROLE_FLG */
		public static final String ROLE_FLG = "roleFlg";

		/** YES */
		public static final String YES = "YES";

		/** NO */
		public static final String NO = "NO";

		/** 是否是初始密码登陆 */
		public static final String IS_INIT_PASS = "isInitPass";

		/** 成功信息 */
		public static final String SUCCESS_MSG = "successMsg";

		/** ERR_MSG */
		public static final String ERR_MSG = "errorMsg";

		/** ALARM_MSG */
		public static final String ALARM_MSG = "alarmMsg";
		
		/** MESSAGE */
		public static final String MESSAGE = "message";

		/** 四个斜杠 */
		public static final String FOURSLASH = "\\\\";

		/** %2F */
		public static final String TWOF = "%2F";
	}

	/**
	 * 日期格式的定义类
	 * 
	 * @version 1.0
	 * @author kevinli
	 */
	public static class DatePattern {

		/** 格式:yyyyMMdd. */
		public static final String DATE_PATTERN_0 = "yyyyMMdd";

		/** 格式:yyyyMMddHHmmssSSS. */
		public static final String DATE_PATTERN_1 = "yyyyMMddHHmmssSSS";

		/** 格式:yyyy/MM/dd. */
		public static final String DATE_PATTERN_2 = "yyyy/MM/dd";

		/** 格式:yyyy/MM/dd HH:mm:ss. */
		public static final String DATE_PATTERN_3 = "yyyy/MM/dd HH:mm:ss";

		/** 格式:yy/MM/dd. */
		public static final String DATE_PATTERN_4 = "yy/MM/dd";

		/** 格式:yyyy/MM/dd HH:mm:ss.SSS. */
		public static final String DATE_PATTERN_5 = "yyyy/MM/dd HH:mm:ss.SSS";

		/** 格式:yyyyMM. */
		public static final String DATE_PATTERN_6 = "yyyyMM";

		/** 格式:yyMMdd. */
		public static final String DATE_PATTERN_7 = "yyMMdd";

		/** 格式:yyyy-MM-dd HH:mm:ss.SSS. */
		public static final String DATE_PATTERN_8 = "yyyy-MM-dd HH:mm:ss";

		/** 格式:yyyy/MM/dd HH:mm. */
		public static final String DATE_PATTERN_9 = "yyyy/MM/dd HH:mm";

		/** 格式:yyyy/MM. */
		public static final String DATE_PATTERN_10 = "yyyy/MM";

		/** 格式:yyyyMMddHHmmss. */
		public static final String DATE_PATTERN_11 = "yyyyMMddHHmmss";

		/** 格式:yyyy年MM月dd日. */
		public static final String DATE_PATTERN_12 = "yyyy年MM月dd日";

		/** 格式:yy/MM. */
		public static final String DATE_PATTERN_13 = "yy/MM";

		/** 格式:yy/MM/dd HH:mm:ss. */
		public static final String DATE_PATTERN_14 = "yy/MM/dd HH:mm:ss";

		/** 格式:yy年MM月dd日. */
		public static final String DATE_PATTERN_15 = "yy年MM月dd日";

		/** 格式:yy/MM/dd HH:mm. */
		public static final String DATE_PATTERN_16 = "yy/MM/dd HH:mm";

		/** 格式:yyyy-MM-dd. */
		public static final String DATE_PATTERN_17 = "yyyy-MM-dd";

		/** 格式:MMM. dd, yyyy. */
		public static final String DATE_PATTERN_18 = "MMM.  dd, yyyy";

		/** 格式:yyyy.MM.dd. */
		public static final String DATE_PATTERN_19 = "yyyy.MM.dd";

		/** 格式:yy.MM.dd. */
		public static final String DATE_PATTERN_20 = "yy.MM.dd";

		/** 格式:MMMMM dd, yyyy */
		public static final String DATE_PATTERN_21 = "MMMMM dd, yyyy";

		/** 格式:yyyy-MM-dd.HH.mm.ss.SSS */
		public static final String DATE_PATTERN_22 = "yyyy-MM-dd.HH.mm.ss.SSS";

		/** 格式:MM/dd. */
		public static final String DATE_PATTERN_23 = "MM/dd";
		/** 格式:YYYY-MM-DD HH24:MI:SS */
		public static final String DATE_PATTERN_24 = "YYYY-MM-DD HH24:MI:SS";
	}

	/**
	 * 文件后缀名定义的类
	 * 
	 * @version 1.0
	 * @author kevinli
	 */
	public static class FileExtension {

		/** 文件后缀名:.zip */
		public static final String ZIP = ".zip";

		/** 文件后缀名:.xls */
		public static final String XLS = ".xls";
	}


	/**
	 * 数字代表的土地类型
	 */
	public static class LandType {

		/**
		 * 转让
		 */
		public static final Integer TRANSFER_TYPE = 0;

		/**
		 * 出租
		 */
		public static final Integer LEASE_TYPE = 1;

		/**
		 * 抵押
		 */
		public static final Integer MORTGAGE_TYPE = 2;

		/**
		 * 需求
		 */
		public static final Integer DEMAND_TYPE = 3;

		/**
		 * 竞价
		 */
		public static final Integer JINGJIA_TYPE = 9;
	}

	/**
	 * 行政区级别
	 */
	public static class RegionLevel {

		/**
		 * 1级
		 */
		public static final short LEVEL1 = 1;

		/**
		 * 2级
		 */
		public static final short LEVEL2 = 2;

		/**
		 * 3级
		 */
		public static final short LEVEL3 = 3;

		/**
		 * 4级
		 */
		public static final short LEVEL4 = 4;
	}

	/**
	 * 图片类型
	 */
	public static class ImageType {

		/**
		 * pjpeg
		 */
		public static final String PJPEG = "image/pjpeg";

		/**
		 * jpeg
		 */
		public static final String JPEG = "image/jpeg";

		/**
		 * png
		 */
		public static final String PNG = "image/png";

		/**
		 * x-png
		 */
		public static final String XPNG = "image/x-png";

		/**
		 * gif
		 */
		public static final String GIF = "image/gif";

		/**
		 * bmp
		 */
		public static final String BMP = "image/bmp";

	}

	/**
	 * 流程走势类型
	 */
	public static class ProcessTrendType {

		/**
		 * 通过
		 */
		public static final String APPROVE = "通过";

		/**
		 * 通过
		 */
		public static final String BACK = "退回";

		/**
		 * 启动
		 */
		public static final String START = "启动";

	}

	/**
	 * 经办人名称
	 */
	public static class AssignName {

		//创建人
		public static final String CREATE = "create";

		//科室负责人
		public static final String KSLEADER = "ksLeader";

		//不动产负责人
		public static final String ESTATELEADER = "estateLeader";

		//分管领导
		public static final String MAINLEADER = "mainLeader";

	}

	/**
	 * 经办人用户名
	 */
	public static class AssignUserName {
		//创建人
		public static final String CREATE = "create";

		//科室负责人
		public static final String KSLEADER = "ksLeader";

		//不动产负责人
		public static final String ESTATELEADER = "estateLeader";

		//分管领导
		public static final String MAINLEADER = "mainLeader";
	}

	/**
	 * 审核进度
	 */
	public static class PublishStatus {

		/**
		 * 待审核
		 */
		public static final int STATE0 = 0;

		/**
		 * 正在审核
		 */
		public static final int STATE1 = 1;

		/**
		 * 审核成功
		 */
		public static final int STATE2 = 2;

		/**
		 * 审核失败
		 */
		public static final int STATE3 = 3;
	}

	/**
	 * 成交进度
	 */
	public static class DealStatus {
		/**
		 * 未成交
		 */
		public static final int STATE0 = 0;

		/**
		 * 已成交
		 */
		public static final int STATE1 = 1;
	}


	/**
	 * 工作流启动key
	 */
	public static class WorkFlowKey {

		/**
		 * 土地流程key
		 */
		public static final String LANDPROCESSKEY = "process";
	}

	/**
	 * 流程节点key
	 */
	public static class UserTaskKey {

		/**
		 * 流程的第一个节点
		 */
		public static final String USERTASK1 = "usertask1";

		/**
		 * 流程的第二个节点
		 */
		public static final String USERTASK2 = "usertask2";

		/**
		 * 流程的第三个节点
		 */
		public static final String USERTASK3 = "usertask3";
	}

	/**
	 * 定义节点走势（通过，退回）
	 */
	public static class FlagName {

		/**
		 * 通过
		 */
		public static final String FORWARD = "forward";

		/**
		 * 退回
		 */
		public static final String BACK = "back";
	}


	/**
	 * 定义地块是否导出
	 */
	public static class ExportStatus {

		/**
		 * 导出
		 */
		public static final int YES = 0;

		/**
		 * 不导出
		 */
		public static final int NO = 1;
	}


	/**
	 * 定义es的mapping类型
	 */
	public static class EsType {

		/**
		 * 日志编码
		 */
		public static final String LOG = "LogMarket";

		/**
		 * 地块
		 */
		public static final String LAND = "TransResourceVo";

		/**
		 * 定义系统索引
		 */
		public static final String INDEX_NAME = "LingBi";
	}

	/**
	 * 定义BeanName路径
	 */
	public static class BeanName {

		/**
		 * beanName常量
		 */
		public static final String BEANNAME = "beanName";

		/**
		 * TransLandTransferController实体类路径
		 */
		public static final String TRANSLANDTRANSFERCONTROLLER = "cn.gtmap.secondaryMarket.server.web.TransLandTransferController";

		/**
		 * TransLandLeaseController实体类路径
		 */
		public static final String TRANSLANDLEASECONTROLLER = "cn.gtmap.secondaryMarket.server.web.TransLandLeaseController";

		/**
		 * TransLandMortgageController实体类路径
		 */
		public static final String TRANSLANDMORTGAGECONTROLLER = "cn.gtmap.secondaryMarket.server.web.TransLandMortgageController";

		/**
		 * TransLandDemandController实体类路径
		 */
		public static final String TRANSLANDDEMANDCONTROLLER = "cn.gtmap.secondaryMarket.server.web.TransLandDemandController";

		/**
		 * TransLandBiddingController实体类路径
		 */
		public static final String TRANSLANDBIDDINGCONTROLLER = "cn.gtmap.secondaryMarket.server.web.TransLandBiddingController";

	}

	/**
	 * 定义MethodName名称（方法名）
	 */
	public static class MethodName {

		/**
		 * 详情页方法名
		 */
		public static final String DETAIL = "detail";
	}

	/**
	 * 定义字典表code
	 */
	public static class DataDictionary {

		/**
		 * 详情页方法名
		 */
		public static final String TDYT = "TDYT";
	}

	/**
	 * 角色名称定义
	 */
	public static class RoleName {

		/**
		 * 管理员账号
		 */
		public static final String ADMIN = "管理员";

		/**
		 * 不动产管理员
		 */
		public static final String ESTATE_ADMIN = "estateAdmin";

		/**
		 * 土地利用科管理员
		 */
		public static final String LAND_USER_ADMIN = "landUserAdmin";
	}

	/**
	 * 行政区代码定义
	 */
	public static class RegionCode {

		/**
		 * 固原市
		 */
		public static final String SUZHOU = "3413";

		/**
		 * 埇桥区
		 */
		public static final String YONGQIAO = "341302";

		/**
		 * 固原
		 */
		public static final String YANTAI = "3706";
		/**
		 * 固原
		 */
		public static final String GUYUAN = "6404";
	}
	
	//合同编号类型
	public static class TransContractType{
		/**
		 * 转让
		 */
		public static final String ZR = "ZR";
		/**
		 * 出租
		 */
		public static final String CZ = "CZ";
		/**
		 * 抵押
		 */
		public static final String DY = "DY";
		
	}

	/**
	 * 定义前台数据字典编码
	 */
	public static class DataCode{
		/**
		 * 转让类型编码
		 */
		public static final String ZRLX = "ZRLX";

		/**
		 * 推介类型编码
		 */
		public static final String TJLX = "TJLX";

		/**
		 * 出租类型编码
		 */
		public static final String CZLX = "CZLX";

		/**
		 * 抵押类型编码
		 */
		public static final String DYLX = "DYLX";

		/**
		 * 发布类型编码
		 */
		public static final String FBLX = "FBLX";

		/**
		 * 资讯类型编码
		 */
		public static final String ZXLX = "ZXLX";

		/**
		 * 置顶类型编码
		 */
		public static final String ZDLX = "ZDLX";


		/**
		 * 启用类型编码
		 */
		public static final String QYLX = "QYLX";


		/**
		 * 失信状态编码
		 */
		public static final String SXZT = "SXZT";

		/**
		 * 服务指南类型编码
		 */
		public static final String FWZNLX = "FWZNLX";

		/**
		 * 会员审核状态编码
		 */
		public static final String HYSHZT = "HYSHZT";
		
		/**
		 * 会员审核状态编码
		 */
		public static final String HTZT = "HTZT";

		/**
		 * 出让类型
		 */
		public static final String CRLX = "CRLX";

		/**
		 * 证件类型
		 */
		public static final String ZJLX = "ZJLX";

		/**
		 * 土地性质
		 */
		public static final String TDXZ = "TDXZ";

		/**
		 * 权属号码
		 */
		public static final String QSHM = "QSHM";

		/**
		 * 权属来源
		 */
		public static final String QSLY = "QSLY";

		/**
		 * 转让方式
		 */
		public static final String ZRFS = "ZRFS";

		/**
		 * 转让范围
		 */
		public static final String ZRFW = "ZRFW";

		/**
		 * 抵押证件类型
		 */
		public static final String DYZJLX = "DYZJLX";

		/**
		 * 代理人类型
		 */
		public static final String DLRLX = "DLRLX";

		/**
		 * 是否发布
		 */
		public static final String SFFB = "SFFB";

		/**
		 * 图片位置
		 */
		public static final String TPWZ = "TPWZ";

		/**
		 * 图片大小
		 */
		public static final String TPDX = "TPDX";

		/**
		 * 机构类型
		 */
		public static final String JGLX = "JGLX";

		/**
		 * 前台标题
		 */
		public static final String TITLE = "TITLE";

		/**
		 * 前台标题
		 */
		public static final String QTBT = "QTBT";

		/**
		 * 后台标题
		 */
		public static final String HTBT = "HTBT";
		
		/**
		 * 交易物类型
		 */
		public static final String LANDTYPE = "LANDTYPE";
		
		/**
		 * 建筑结构
		 */
		public static final String JZJG = "JZJG";
		
		/**
		 * 权属人性质
		 */
		public static final String QSRXZ = "QSRXZ";

		/**
		 * 资格审核
		 */
		public static final String ZGSH = "ZGSH";
		
		/**
		 * 土地用途
		 */
		public static final String TDYT = "TDYT";
	}

	public static final String DEFAULT_CHARSET_NAME = "UTF-8";

	public static class startPeopleType {

		/**
		 * 个人
		 */
		public static final int PERSONAL = 0;

		/**
		 * 角色下面的所有人
		 */
		public static final int ROLE = 1;

	}

	/**
	 * 土地使用权性质
	 */
	public static class landUseType {

		/**
		 * 出让
		 */
		public static final String SELL = "0";

		/**
		 * 划拨
		 */
		public static final String HUABO = "1";

	}
}
