/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.util.redisson;

import cn.gtmap.realestate.common.core.annotations.RedissonLock;
import cn.gtmap.realestate.common.core.ex.AppException;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Aspect
@Order(value=1)
public class RedissonLockService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedissonLockService.class);
    private static final String CLASS_NAME = RedissonLockService.class.getName();
    @Autowired
    private RedissonClient redissonClient;

    @Pointcut(value="@annotation(cn.gtmap.realestate.common.core.annotations.RedissonLock)")
    private void point() {
    }

    @Around(value="point()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        RedissonLock redissonLock = method.getAnnotation(RedissonLock.class);
        String description = redissonLock.description();
        RLock lock = this.getLock(redissonLock);
        try {
            boolean lockResult = lock.tryLock(redissonLock.waitTime(), redissonLock.leaseTime(), redissonLock.unit());
            if (!lockResult) {
                LOGGER.warn("{}\uff1a{}\u83b7\u53d6\u9501\u5931\u8d25\uff0c\u5904\u7406\u4e2d\u6b62\uff01", (Object)CLASS_NAME, (Object)description);
                Object var8_9 = null;
                return var8_9;
            }
            Object object = joinPoint.proceed();
            return object;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new AppException(description + "\u5904\u7406\u52a0\u9501\u903b\u8f91\u5931\u8d25\uff01");
        }
        finally {
            if (null != lock) {
                lock.unlock();
            }
        }
    }

    private RLock getLock(RedissonLock redissonLock) {
        switch (redissonLock.lockType()) {
            case REENTRANT_LOCK: {
                return this.redissonClient.getLock(redissonLock.lockKey());
            }
            case FAIR_LOCK: {
                return this.redissonClient.getFairLock(redissonLock.lockKey());
            }
            case READ_LOCK: {
                return this.redissonClient.getReadWriteLock(redissonLock.lockKey()).readLock();
            }
            case WRITE_LOCK: {
                return this.redissonClient.getReadWriteLock(redissonLock.lockKey()).writeLock();
            }
        }
        throw new AppException("\u76ee\u524d\u4e0d\u652f\u6301\u7684Redisson\u9501\u7c7b\u578b:" + redissonLock.lockType().name());
    }
}

