/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.util.redisson;

import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RedissonConfig {
    @Resource
    private RedisProperties redisProperties;

    @Bean
    public RedissonClient getRedissonClient() {
        Config config = new Config();
        if (this.redisProperties.getCluster() != null && CollectionUtils.isNotEmpty((Collection)this.redisProperties.getCluster().getNodes())) {
            List nodeList = this.redisProperties.getCluster().getNodes();
            String[] arr = new String[nodeList.size()];
            for (int i = 0; i < nodeList.size(); ++i) {
                arr[i] = "redis://" + (String)nodeList.get(i);
            }
            config.useClusterServers().addNodeAddress(arr);
        } else {
            config.useSingleServer().setAddress("redis://" + this.redisProperties.getHost() + ":" + this.redisProperties.getPort());
        }
        return Redisson.create((Config)config);
    }
}

