/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.util.encrypt;

import cn.gtmap.realestate.common.util.Base64Utils;
import cn.gtmap.realestate.common.util.encrypt.SM2;
import cn.gtmap.realestate.common.util.encrypt.SM2KeyPair;
import cn.gtmap.realestate.common.util.encrypt.Signature;
import java.math.BigInteger;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.math.ec.ECPoint;

public class SM2Util {
    public static final String SM2_KEY_ID = "DZZZ_GTMAP_SM2_ID";
    public static final String SM2_PUBLIC_KEY = "04da8af16d13ec0f287fe2c54f4eac4936cd65c10d261050836bdd4806cb3124916ce12b3ff98659c3f93c38f1e925ef8cacc3a8151d5cd30d6eca125b613c1fb8";
    public static final String SM2_PRIVATE_KEY = "00c0354ae90137495ca05c38cfc0c3c600a2694739c41ca19033ae1f5356a2181f";
    private static final SM2 SM_2 = new SM2(false);
    public static final SM2KeyPair KEYPAIR = SM2KeyPair.getInstance();

    private SM2Util() {
    }

    public static SM2KeyPair getKeyPair() {
        return SM_2.generateKeyPair();
    }

    public static String encrypt(String inputStr, String publicKeyStr) {
        String result = null;
        if (StringUtils.isNotBlank((CharSequence)inputStr) && StringUtils.isNotBlank((CharSequence)publicKeyStr)) {
            ECPoint publicKey = SM2.curve.decodePoint(Base64Utils.decodeBase64StrToByte(publicKeyStr));
            byte[] data = SM_2.encrypt(inputStr, publicKey);
            result = Base64Utils.encodeByteToBase64Str(data);
        }
        return result;
    }

    public static String decrypt(String encryptData, String privateKeyStr) {
        String result = null;
        if (StringUtils.isNotBlank((CharSequence)encryptData) && StringUtils.isNotBlank((CharSequence)privateKeyStr)) {
            BigInteger privateKey = new BigInteger(Base64Utils.decodeBase64StrToByte(privateKeyStr));
            result = SM_2.decrypt(Base64Utils.decodeBase64StrToByte(encryptData), privateKey);
        }
        return result;
    }

    public static String SM2Sign(String M, String IDA) {
        Signature signature;
        String signStr = null;
        if (StringUtils.isNotBlank((CharSequence)IDA) && null != (signature = SM_2.sign(M, IDA, KEYPAIR))) {
            signStr = signature.getEncode();
        }
        return signStr;
    }
}

