/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.util.encrypt;

import cn.gtmap.realestate.common.util.DataUtil;
import cn.gtmap.realestate.common.util.encrypt.SM2;
import java.math.BigInteger;
import org.bouncycastle.math.ec.ECPoint;

public class SM2KeyPair {
    private static SM2KeyPair instance;
    private final ECPoint publicKey;
    private final BigInteger privateKey;

    public SM2KeyPair(ECPoint publicKey, BigInteger privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized SM2KeyPair getInstance() {
        if (instance != null) return instance;
        Class<SM2KeyPair> clazz = SM2KeyPair.class;
        synchronized (SM2KeyPair.class) {
            byte[] pubArr;
            if (instance != null || null == (pubArr = DataUtil.hexStringToBytes("04da8af16d13ec0f287fe2c54f4eac4936cd65c10d261050836bdd4806cb3124916ce12b3ff98659c3f93c38f1e925ef8cacc3a8151d5cd30d6eca125b613c1fb8"))) return instance;
            ECPoint publicKey = SM2.curve.decodePoint(pubArr);
            BigInteger privateKey = new BigInteger(DataUtil.hexStringToBytes("00c0354ae90137495ca05c38cfc0c3c600a2694739c41ca19033ae1f5356a2181f"));
            if (null == publicKey) return instance;
            instance = new SM2KeyPair(publicKey, privateKey);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public ECPoint getPublicKey() {
        return this.publicKey;
    }

    public BigInteger getPrivateKey() {
        return this.privateKey;
    }
}

