/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.util;

import cn.gtmap.realestate.common.core.domain.BdcTsywPzDO;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.YamlMapFactoryBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class YmlReadUtil {
    public static final String YML_REGEX = "^.+.yml$";
    public static final String YML_NAME = "application-%s.yml";
    public static final String ACTIVE_YML_KEY = "spring.profiles.active";
    public static final String INCLUDE_YML_KEY = "spring.profiles.include";
    public static final String ROOT_YML_NAME = "bootstrap.yml";
    private static final Logger LOGGER = LoggerFactory.getLogger(YmlReadUtil.class);

    public static Map readAllYmlForMap(String location) throws IOException {
        String activeYmlKey;
        Map map = YmlReadUtil.readYmlByMap(location, ROOT_YML_NAME);
        if (Objects.nonNull(map) && StringUtils.isNotBlank((CharSequence)(activeYmlKey = (String)YmlReadUtil.getValue(map, ACTIVE_YML_KEY)))) {
            String[] inculdeYmlKeys;
            map.putAll(Optional.ofNullable(YmlReadUtil.readYmlByMap(location, String.format(YML_NAME, activeYmlKey))).orElse(new HashMap()));
            String includeYmlKey = (String)YmlReadUtil.getValue(map, INCLUDE_YML_KEY);
            if (StringUtils.isNotBlank((CharSequence)includeYmlKey) && Objects.nonNull(inculdeYmlKeys = includeYmlKey.split(",")) && inculdeYmlKeys.length > 0) {
                for (String key : inculdeYmlKeys) {
                    if (!StringUtils.isNotBlank((CharSequence)key)) continue;
                    map.putAll(Optional.ofNullable(YmlReadUtil.readYmlByMap(location, String.format(YML_NAME, key))).orElse(new HashMap()));
                }
            }
        }
        return map;
    }

    private static Object getValue(Map map, String key) {
        if (Objects.isNull(map)) {
            return null;
        }
        String[] keys = key.split("\\.", 2);
        if (keys.length == 2) {
            return YmlReadUtil.getValue((Map)map.get(keys[0]), keys[1]);
        }
        return map.get(keys[0]);
    }

    public static Map readYmlByMap(String location, String fileName) {
        String path = location + fileName;
        LOGGER.info("\u83b7\u53d6\u6587\u4ef6\uff1a{}", (Object)path);
        try {
            YamlMapFactoryBean yamlMapFactoryBean = new YamlMapFactoryBean();
            yamlMapFactoryBean.setResources(new Resource[]{new ClassPathResource(path)});
            yamlMapFactoryBean.afterPropertiesSet();
            return yamlMapFactoryBean.getObject();
        }
        catch (Exception e) {
            LOGGER.error("read {} file for Map has exception: {}", new Object[]{path, e.getMessage(), e});
            return null;
        }
    }

    public static String getMapValWithKeySplit(Map map, String key) {
        Object val = YmlReadUtil.getValue(map, key);
        if (Objects.isNull(val)) {
            return null;
        }
        if (val instanceof Map) {
            return JSON.toJSONString((Object)val);
        }
        return String.valueOf(val);
    }

    public static String getMapVal(Map map, String key) {
        Object val = map.get(key);
        if (Objects.isNull(val)) {
            return null;
        }
        if (val instanceof Map) {
            return JSON.toJSONString(val);
        }
        return String.valueOf(val);
    }

    public static String handleArrayData(Map<String, String> importConfigMap, BdcTsywPzDO bdcTsywPzDO) {
        HashMap<String, String> arrayDataMap = new HashMap<String, String>();
        String pzmc = bdcTsywPzDO.getPzmc();
        for (Map.Entry<String, String> entry : importConfigMap.entrySet()) {
            String entryKey = entry.getKey();
            if (!entryKey.contains(pzmc) || entryKey.length() < pzmc.length() + 1) continue;
            arrayDataMap.put(entryKey.substring(pzmc.length() + 1), entry.getValue());
        }
        if (MapUtils.isNotEmpty(arrayDataMap)) {
            return JSON.toJSONString(arrayDataMap);
        }
        return null;
    }
}

