/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.util;

import cn.gtmap.gtc.workflow.clients.manage.FlowableNodeClient;
import cn.gtmap.gtc.workflow.clients.manage.ProcessDefinitionClient;
import cn.gtmap.gtc.workflow.clients.manage.ProcessTaskClient;
import cn.gtmap.gtc.workflow.domain.manage.ProcessDefData;
import cn.gtmap.gtc.workflow.domain.manage.TaskData;
import cn.gtmap.gtc.workflow.domain.manage.UserTaskDto;
import cn.gtmap.realestate.common.core.ex.MissingArgumentException;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkFlowUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkFlowUtils.class);
    @Autowired
    FlowableNodeClient flowableNodeClient;
    @Autowired
    ProcessDefinitionClient processDefinitionClient;
    @Autowired
    ProcessTaskClient processTaskClient;

    public List<UserTaskDto> getUserTaskByGzlslid(String gzlslid) {
        if (StringUtils.isEmpty((CharSequence)gzlslid)) {
            throw new MissingArgumentException("\u83b7\u53d6\u5e73\u53f0\u7528\u6237\u4efb\u52a1\u4fe1\u606f\u7f3a\u5c11\u53c2\u6570gzlslid\uff0c\u8bf7\u68c0\u67e5\u5bf9\u5e94\u53c2\u6570\u662f\u5426\u6b63\u786e\uff01");
        }
        return this.flowableNodeClient.getAllUserTaskByProcInsId(gzlslid);
    }

    public List<UserTaskDto> listShjdxx(String gzlslid) {
        if (StringUtils.isEmpty((CharSequence)gzlslid)) {
            throw new MissingArgumentException("gzlslid,\u8bf7\u68c0\u67e5\u5728\u83b7\u53d6\u5ba1\u6838\u8282\u70b9\u4fe1\u606f\u65f6\u4f20\u5165\u7684\u53c2\u6570\u662f\u5426\u6b63\u786e\uff01");
        }
        List<Object> userTaskDataList = null;
        try {
            userTaskDataList = this.getUserTaskByGzlslid(gzlslid);
            userTaskDataList = userTaskDataList.stream().filter(task -> CollectionUtils.isNotEmpty((Collection)task.getFormProperties().stream().filter(property -> StringUtils.equalsIgnoreCase((CharSequence)property.getName(), (CharSequence)"sign") && Boolean.valueOf(property.getVariable()) != false).collect(Collectors.toList()))).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5e73\u53f0\u8282\u70b9\u4fe1\u606f\u5931\u8d25_" + e.getMessage(), (Throwable)e);
            userTaskDataList = this.initDefaultShjdxx();
        }
        return userTaskDataList;
    }

    public List<UserTaskDto> initDefaultShjdxx() {
        UserTaskDto cs = new UserTaskDto();
        UserTaskDto fs = new UserTaskDto();
        UserTaskDto hd = new UserTaskDto();
        cs.setName("\u521d\u5ba1");
        cs.setId("cs");
        fs.setName("\u590d\u5ba1");
        fs.setId("fs");
        hd.setName("\u6838\u5b9a");
        hd.setId("hd");
        return Lists.newArrayList((Object[])new UserTaskDto[]{cs, fs, hd});
    }

    public List<ProcessDefData> getAllProcessDefData() {
        return this.processDefinitionClient.getAllProcessDefData();
    }

    public ProcessDefData getAllProcessDefDataByGzldyid(String gzldyid) {
        if (StringUtils.isBlank((CharSequence)gzldyid)) {
            throw new MissingArgumentException("\u6839\u636e\u5de5\u4f5c\u6d41\u5b9a\u4e49ID\u83b7\u53d6\u6d41\u7a0b\u4fe1\u606f");
        }
        return this.processDefinitionClient.getProcessDefByProcessDefKey(gzldyid);
    }

    public List<UserTaskDto> getUserTasks(String processDefKey) {
        return this.flowableNodeClient.getAllUserTaskByProcDefKey(processDefKey);
    }

    public TaskData getTaskById(String taskId) {
        return this.processTaskClient.getTaskById(taskId);
    }
}

