/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.util;

import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.XMLType;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.xfire.client.Client;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WebServiceUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebServiceUtils.class);

    public static String callWebService(String url, String uri, String methodName, String[] paramNameArray, Object[] paramValArray) {
        String result = "";
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{url})) {
            try {
                Service service = new Service();
                Call call = (Call)service.createCall();
                call.setTargetEndpointAddress(url);
                call.setOperationName(new QName(uri, methodName));
                call.setUseSOAPAction(true);
                call.setSOAPActionURI(uri + methodName);
                call.setProperty("axis.connection.timeout", (Object)20000);
                call.setTimeout(Integer.valueOf(20000));
                for (int i = 0; i < paramNameArray.length; ++i) {
                    QName qName = XMLType.XSD_STRING;
                    if (i < paramValArray.length && paramValArray[i] instanceof Integer) {
                        qName = XMLType.XSD_INTEGER;
                    }
                    call.addParameter(new QName(uri, paramNameArray[i]), qName, ParameterMode.IN);
                }
                call.setReturnType(XMLType.XSD_STRING);
                result = (String)call.invoke(paramValArray);
            }
            catch (RemoteException e) {
                LOGGER.error("RemoteException", (Throwable)e);
            }
            catch (ServiceException e) {
                LOGGER.error("ServiceException", (Throwable)e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String callWebService(String url, String method, Object[] param) {
        String result = "";
        Object[] results = null;
        try (Client client = null;){
            client = new Client(new URL(url));
            results = client.invoke(method, param);
        }
        if (results != null) {
            result = results[0].toString();
        }
        return result;
    }
}

