/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.util;

import cn.gtmap.gtc.clients.UserManagerClient;
import cn.gtmap.gtc.sso.domain.dto.OrganizationDto;
import cn.gtmap.gtc.sso.domain.dto.RoleDto;
import cn.gtmap.gtc.sso.domain.dto.UserDto;
import cn.gtmap.realestate.common.core.ex.MissingArgumentException;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class UserManagerUtils {
    @Autowired
    private UserManagerClient userManagerClient;

    public UserDto getUserByName(String userName) {
        if (StringUtils.isBlank((CharSequence)userName)) {
            return null;
        }
        return this.userManagerClient.getUserDetailByUsername(userName);
    }

    public UserDto getCurrentUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (null == authentication || StringUtils.isBlank((CharSequence)authentication.getName())) {
            return null;
        }
        return this.getUserByName(authentication.getName());
    }

    public List<OrganizationDto> getOrgListByUserName(String userName) {
        if (StringUtils.isBlank((CharSequence)userName)) {
            return Collections.emptyList();
        }
        UserDto userDto = this.getUserByName(userName);
        if (null == userDto || StringUtils.isBlank((CharSequence)userDto.getUsername())) {
            return Collections.emptyList();
        }
        return userDto.getOrgRecordList();
    }

    public String getCurrentUserOrgCode() {
        UserDto userDto = this.getCurrentUser();
        if (null == userDto || StringUtils.isBlank((CharSequence)userDto.getUsername())) {
            return "";
        }
        return this.getOrgCodeByUserName(userDto.getUsername());
    }

    public String getOrgCodeByUserName(String userName) {
        if (StringUtils.isBlank((CharSequence)userName)) {
            return null;
        }
        List<OrganizationDto> organizationDtoList = this.getOrgListByUserName(userName);
        if (CollectionUtils.isEmpty(organizationDtoList)) {
            return "";
        }
        OrganizationDto organizationDto = (OrganizationDto)CollectionUtils.get(organizationDtoList, (int)0);
        return organizationDto.getCode();
    }

    public String getRegionCodeByUserName(String userName) {
        if (StringUtils.isBlank((CharSequence)userName)) {
            return null;
        }
        List<OrganizationDto> organizationDtoList = this.getOrgListByUserName(userName);
        if (CollectionUtils.isEmpty(organizationDtoList)) {
            return "";
        }
        OrganizationDto organizationDto = (OrganizationDto)CollectionUtils.get(organizationDtoList, (int)0);
        return organizationDto.getRegionCode();
    }

    public String getCurrentUserName() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && StringUtils.isNotBlank((CharSequence)authentication.getName())) {
            return authentication.getName();
        }
        return "";
    }

    public String getOrganizationByUserName(String userName) {
        List<OrganizationDto> organizationDtos;
        if (StringUtils.isNotBlank((CharSequence)userName) && CollectionUtils.isNotEmpty(organizationDtos = this.getOrgListByUserName(userName))) {
            return organizationDtos.get(0).getName();
        }
        return "";
    }

    public String getUserSignByUserName(String userName) {
        if (StringUtils.isEmpty((CharSequence)userName)) {
            throw new MissingArgumentException("userName");
        }
        return this.userManagerClient.getUserSign(userName);
    }

    public UserDto getUserByUserid(String userId) {
        return this.userManagerClient.getUserDetail(userId);
    }

    public List<RoleDto> getRolesByUserId(String userId) {
        if (StringUtils.isBlank((CharSequence)userId)) {
            return null;
        }
        return this.userManagerClient.findRoles(userId);
    }

    public boolean isAdminByUserId(String userId) {
        if (StringUtils.isBlank((CharSequence)userId)) {
            return false;
        }
        List<RoleDto> roleList = this.getRolesByUserId(userId);
        if (CollectionUtils.isNotEmpty(roleList)) {
            for (RoleDto role : roleList) {
                if (role == null || !StringUtils.equals((CharSequence)role.getName(), (CharSequence)"admin")) continue;
                return true;
            }
        }
        return false;
    }
}

