/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.util;

import cn.gtmap.realestate.common.core.ex.AppException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Calendar;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.commons.lang3.StringUtils;

public final class UUIDGenerator {
    private static final AtomicInteger counter;
    private static final int JVM;
    private static final int IP;
    private static final Logger LOG;
    private static final String identifier;

    private UUIDGenerator() {
    }

    private static int toInt(byte[] bytes) {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result = (result << 8) - -128 + bytes[i];
        }
        return result;
    }

    private static short getCount() {
        counter.compareAndSet(Short.MAX_VALUE, 0);
        return (short)counter.incrementAndGet();
    }

    private static String format(int intValue) {
        return StringUtils.leftPad((String)Integer.toHexString(intValue), (int)8, (String)"0");
    }

    private static String format(short shortValue) {
        return StringUtils.leftPad((String)Integer.toHexString(shortValue), (int)4, (String)"0");
    }

    public static String generate() {
        UUID uuid = UUID.randomUUID();
        String id = null;
        if (uuid == null) {
            throw new AppException("generate\u65b9\u6cd5\u751f\u6210UUID\u5f02\u5e38");
        }
        id = StringUtils.replace((String)uuid.toString(), (String)"-", (String)"");
        return id;
    }

    public static String generate16() {
        return String.valueOf(UUIDGenerator.getLngTime() + identifier + UUIDGenerator.generate16GetCount());
    }

    private static String generate16GetCount() {
        counter.compareAndSet(46656, 0);
        return UUIDGenerator.formatString(UUIDGenerator.getHex36String(counter.incrementAndGet()), 3);
    }

    private static String getFileNum() {
        return UUIDGenerator.formatString(String.valueOf(UUIDGenerator.getInstanceSeq()), 1);
    }

    private static int BytestoInt(byte[] bytes) {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result = (result << 8) - -128 + bytes[i];
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private static byte[] getInetAddress() {
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
            block2: while (true) {
                if (!interfaces.hasMoreElements()) {
                    return null;
                }
                ni = interfaces.nextElement();
                if (ni.isLoopback() || ni.isVirtual() || ni.isPointToPoint() || !ni.isUp() || (name = ni.getDisplayName().toLowerCase()).contains("convnet") || name.contains("vmnet")) continue;
                addresses = ni.getInetAddresses();
                do {
                    if (addresses.hasMoreElements()) ** break;
                    continue block2;
                } while ((addr = addresses.nextElement().getAddress()).length != 4);
                break;
            }
            return addr;
        }
        catch (Exception var5) {
            UUIDGenerator.LOG.warning("Error to get ip address");
            return null;
        }
    }

    private static String getIP() {
        int ip = 0;
        try {
            ip = UUIDGenerator.BytestoInt(UUIDGenerator.getInetAddress());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return UUIDGenerator.formatString(UUIDGenerator.getHex36String(ip), 2);
    }

    private static byte getInstanceSeq() {
        Preferences prefs = Preferences.userRoot().node("egov");
        int seq = prefs.getInt("uuid-seq", 0);
        if (seq > 36) {
            seq = 0;
        }
        prefs.putInt("uuid-seq", ++seq);
        try {
            prefs.flush();
        }
        catch (BackingStoreException var3) {
            LOG.warning("Error to save uuid-seq");
        }
        return (byte)seq;
    }

    private static String getHex36String(int value) {
        return Integer.toString(value, 36).toUpperCase();
    }

    private static String getHex36String(long value) {
        return Long.toString(value, 36).toUpperCase();
    }

    private static String formatString(String str, int length) {
        if (str.length() == length) {
            return str;
        }
        if (str.length() > length) {
            return str.substring(str.length() - length, str.length());
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < length - str.length(); ++i) {
            buf.append("0");
        }
        return buf.append(str).toString();
    }

    private static String getLngTime() {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        int millSecond = calendar.get(14);
        return UUIDGenerator.formatString(UUIDGenerator.getHex36String(year), 1) + UUIDGenerator.getHex36String(month) + UUIDGenerator.getHex36String(day) + UUIDGenerator.getHex36String(hour) + UUIDGenerator.formatString(String.valueOf(minute), 2) + UUIDGenerator.formatString(String.valueOf(second), 2) + UUIDGenerator.formatString(UUIDGenerator.getHex36String(millSecond), 2);
    }

    static {
        int ipadd;
        LOG = Logger.getLogger(UUIDGenerator.class.getName());
        identifier = UUIDGenerator.getIP() + UUIDGenerator.getFileNum();
        counter = new AtomicInteger(0);
        JVM = (int)(System.currentTimeMillis() >>> 8);
        try {
            ipadd = UUIDGenerator.toInt(InetAddress.getLocalHost().getAddress());
        }
        catch (Exception e) {
            ipadd = 0;
        }
        IP = ipadd;
    }
}

