/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.util;

import cn.gtmap.realestate.common.core.domain.BdcQlrDO;
import cn.gtmap.realestate.common.core.ex.AppException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringToolUtils
extends StringUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringToolUtils.class);
    private static final String CLASS_NAME = StringToolUtils.class.getName();
    public static final String ENCODING_UTF8 = "UTF-8";
    public static final String ENCODING_GBK = "GBK";
    private static final String[] Numbers = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    private static final String[] TenString = new String[]{"\u5341", "\u4e8c\u5341", "\u4e09\u5341"};

    public static <T> String resolveBeanToAppendStr(List<T> beanList, String methodName, String sign) {
        if (CollectionUtils.isEmpty(beanList) || StringUtils.isBlank((CharSequence)methodName)) {
            LOGGER.warn("{}\uff1a\u62fc\u63a5\u5b57\u7b26\u4e32\u7ec8\u6b62\uff0c\u539f\u56e0\uff1a\u672a\u6307\u5b9a\u9700\u6267\u884cbean\u3001\u65b9\u6cd5\u540d", (Object)CLASS_NAME);
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)sign)) {
            sign = ",";
        }
        StringBuilder builder = new StringBuilder(100);
        try {
            for (T bean : beanList) {
                Method method;
                Object obj;
                if (null == bean || (obj = (method = bean.getClass().getMethod(methodName, new Class[0])).invoke(bean, new Object[0])) == null) continue;
                builder.append(String.valueOf(obj)).append(sign);
            }
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("{}\uff1a\u89e3\u6790bean\u62fc\u63a5\u5b57\u7b26\u4e32\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u76ee\u6807bean\u6ca1\u6709\u6307\u5b9a\u65b9\u6cd5{}", (Object)CLASS_NAME, (Object)methodName);
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOGGER.error("{}\uff1a\u89e3\u6790bean\u62fc\u63a5\u5b57\u7b26\u4e32\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u76ee\u6807bean\u6267\u884c\u5931\u8d25", (Object)CLASS_NAME);
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        String str = builder.toString();
        if (StringUtils.isBlank((CharSequence)str)) {
            LOGGER.warn("{}\uff1a\u89e3\u6790bean\u62fc\u63a5\u5b57\u7b26\u4e32\u7ed3\u679c\u4e3a\u7a7a\uff01", (Object)CLASS_NAME);
            return null;
        }
        return str.substring(0, str.length() - sign.length());
    }

    public static String getZjzlOfZd(List<BdcQlrDO> bdcQlrList, List<Map> zjzlZd) {
        return StringToolUtils.convertBeanPropertiesValueOfZd(bdcQlrList, "zjzl", zjzlZd);
    }

    public static <T> String convertBeanPropertiesValueOfZd(List<T> beansList, String propertyName, List<Map> zdList) {
        if (CollectionUtils.isEmpty(beansList) || StringUtils.isBlank((CharSequence)propertyName) || CollectionUtils.isEmpty(zdList)) {
            LOGGER.warn("{}\uff1a\u53c2\u6570\u4e3a\u7a7a\uff0c\u8f6c\u6362\u5b9e\u4f53\u5c5e\u6027\u5b57\u5178\u4e2d\u6b62\uff01", (Object)CLASS_NAME);
            return null;
        }
        StringBuilder builder = new StringBuilder(100);
        try {
            for (T bean : beansList) {
                if (null == bean) continue;
                Field field = bean.getClass().getDeclaredField(propertyName);
                field.setAccessible(true);
                for (Map map : zdList) {
                    if (null == field.get(bean) || MapUtils.getInteger((Map)map, (Object)"DM") == null || Integer.parseInt(String.valueOf(field.get(bean))) != MapUtils.getInteger((Map)map, (Object)"DM")) continue;
                    builder.append(MapUtils.getString((Map)map, (Object)"MC")).append(",");
                }
            }
            String value = builder.toString();
            if (StringUtils.isBlank((CharSequence)value)) {
                return value;
            }
            return value.substring(0, value.length() - 1);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new AppException("\u8f6c\u6362\u5b9e\u4f53\u5c5e\u6027\u5b57\u5178\u51fa\u9519\uff01");
        }
    }

    public static String convertBeanPropertyValueOfZd(Integer propertyValue, List<Map> zdList) {
        if (null == propertyValue || CollectionUtils.isEmpty(zdList)) {
            return null;
        }
        for (Map map : zdList) {
            if (propertyValue.intValue() != MapUtils.getInteger((Map)map, (Object)"DM").intValue()) continue;
            return MapUtils.getString((Map)map, (Object)"MC");
        }
        return propertyValue.toString();
    }

    public static Boolean containsTargetStr(String str, Set<String> targetStrSet) {
        if (StringUtils.isBlank((CharSequence)str) || CollectionUtils.isEmpty(targetStrSet)) {
            return false;
        }
        for (String targerStr : targetStrSet) {
            if (!str.contains(targerStr)) continue;
            return true;
        }
        return false;
    }

    public static Boolean containsTargetStr(String str, String ... targetStrCollection) {
        if (StringUtils.isBlank((CharSequence)str) || ArrayUtils.isEmpty((Object[])targetStrCollection)) {
            return false;
        }
        for (String targerStr : targetStrCollection) {
            if (!str.contains(targerStr)) continue;
            return true;
        }
        return false;
    }

    public static boolean existItemNullOrEmpty(String ... strArray) {
        if (ArrayUtils.isEmpty((Object[])strArray)) {
            return true;
        }
        for (String str : strArray) {
            if (!StringUtils.isEmpty((CharSequence)str)) continue;
            return true;
        }
        return false;
    }

    public static boolean existIntegerItemNullOrEmpty(Integer ... integerArray) {
        if (ArrayUtils.isEmpty((Object[])integerArray)) {
            return true;
        }
        for (Integer item : integerArray) {
            if (null != item) continue;
            return true;
        }
        return false;
    }

    public static boolean existItemEquals(String str, String ... strArray) {
        if (StringUtils.isBlank((CharSequence)str) || ArrayUtils.isEmpty((Object[])strArray)) {
            return false;
        }
        for (String item : strArray) {
            if (!StringUtils.equals((CharSequence)str, (CharSequence)item)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllNullOrEmpty(String ... strArray) {
        if (ArrayUtils.isEmpty((Object[])strArray)) {
            return true;
        }
        for (String str : strArray) {
            if (!StringUtils.isNotBlank((CharSequence)str)) continue;
            return false;
        }
        return true;
    }

    public static String replaceBracket(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        if (str.indexOf("\uff08") != -1) {
            str = str.replaceAll("\uff08", "(");
        }
        if (str.indexOf("\uff09") != -1) {
            str = str.replaceAll("\uff09", ")");
        }
        return str;
    }

    public static String appendZero(String str, int len) {
        if (StringUtils.isBlank((CharSequence)str) || len < str.length()) {
            return str;
        }
        if (str.length() < len) {
            while ((str = StringUtils.join((Object[])new String[]{"0", str})).length() < len) {
            }
        }
        return str;
    }

    public static String getChineseDate() {
        LocalDateTime localDate = LocalDateTime.now();
        String[] year = String.valueOf(localDate.getYear()).split("");
        StringBuilder chinesDate = new StringBuilder();
        for (int i = 0; i < year.length; ++i) {
            chinesDate.append(StringToolUtils.convert(year[i]));
        }
        chinesDate.append("\u5e74");
        String month = String.valueOf(localDate.getMonthValue());
        chinesDate.append(StringToolUtils.convertMonthAndDay(month)).append("\u6708");
        String day = String.valueOf(localDate.getDayOfMonth());
        chinesDate.append(StringToolUtils.convertMonthAndDay(day)).append("\u65e5");
        return chinesDate.toString();
    }

    private static String convertMonthAndDay(String value) {
        String[] number = value.split("");
        if (number.length == 1) {
            return StringToolUtils.convert(number[0]);
        }
        if (number[0].equals("0")) {
            return StringToolUtils.convert(number[1]);
        }
        String tenStr = TenString[Integer.valueOf(number[0]) - 1];
        if (number[1].equals("0")) {
            return tenStr;
        }
        return tenStr + StringToolUtils.convert(number[1]);
    }

    private static String convert(String val) {
        return Numbers[Integer.valueOf(val)];
    }

    public static String replaceXml(String key, Object value, String xml) {
        xml = xml.replaceAll("\\>\\$" + StringUtils.upperCase((String)key) + "\\<", "\\>" + value + "\\<");
        xml = xml.replaceAll("\\>\\$" + StringUtils.lowerCase((String)key) + "\\<", "\\>" + value + "\\<");
        xml = xml.replaceAll("\\>\\$" + key + "\\<", "\\>" + value + "\\<");
        xml = xml.replaceAll("\\$\\{[" + StringUtils.upperCase((String)key) + "}]+\\}", String.valueOf(value));
        xml = xml.replaceAll("\\$\\{[" + StringUtils.lowerCase((String)key) + "}]+\\}", String.valueOf(value));
        xml = xml.replaceAll("\\$\\{[" + key + "}]+\\}", String.valueOf(value));
        return xml;
    }

    public static String appendSqlInStr(List<String> stringList) {
        String sqlStr = "";
        StringBuilder stringBuilder = new StringBuilder(sqlStr);
        if (CollectionUtils.isNotEmpty(stringList)) {
            stringBuilder.append("(");
            for (String str : stringList) {
                stringBuilder.append("'").append(str).append("',");
            }
            sqlStr = stringBuilder.toString();
            sqlStr = sqlStr.substring(0, sqlStr.length() - 1);
            sqlStr = sqlStr + ")";
        }
        return sqlStr;
    }

    public static byte[] strToByteUtf8(String str) {
        return StringToolUtils.strToByte(str, ENCODING_UTF8);
    }

    public static byte[] strToByte(String str, String encode) {
        byte[] b = null;
        if (StringUtils.isNotBlank((CharSequence)str)) {
            try {
                b = str.getBytes(encode);
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("StringUtils-strToByteUtf8 --\u300b", (Throwable)e);
            }
        }
        return b;
    }

    public static String byteToStrUtf8(byte[] b) {
        return StringToolUtils.byteToStr(b, ENCODING_UTF8);
    }

    public static String byteToStr(byte[] b, String encode) {
        String str = null;
        if (null != b) {
            try {
                str = new String(b, encode);
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("StringUtils-byteToStrUtf8 --\u300b", (Throwable)e);
            }
        }
        return str;
    }
}

