/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.util;

import cn.gtmap.realestate.common.core.ex.AppException;
import cn.gtmap.realestate.common.core.support.mybatis.mapper.EntityHelper;
import com.alibaba.fastjson.JSONObject;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.jdbc.SQL;

public class SqlUtils {
    private static final String RECORDMARK = "=#{record.";

    public static String getBatchUpdateStatement(JSONObject jsonObject, String className) {
        SQL sql = new SQL();
        Set keySet = jsonObject.keySet();
        try {
            EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(Class.forName(className));
            sql.UPDATE(entityTable.getName());
            for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                String type = SqlUtils.getjdbcType(column.getJavaType().getSimpleName());
                if (column.isId() || !keySet.contains(column.getProperty())) continue;
                sql.SET(column.getColumn() + RECORDMARK + column.getProperty() + "," + type + "}");
            }
        }
        catch (ClassNotFoundException e) {
            throw new AppException("\u66f4\u65b0\u5b9e\u4f53\u6570\u636e\u5f02\u5e38\uff01");
        }
        return sql.toString();
    }

    private static String getjdbcType(String type) {
        String str = "";
        if (StringUtils.equals((CharSequence)type.toUpperCase(), (CharSequence)"DATE")) {
            str = "jdbcType=TIMESTAMP";
        }
        if (StringUtils.equals((CharSequence)type.toUpperCase(), (CharSequence)"STRING")) {
            str = "jdbcType=VARCHAR";
        }
        if (StringUtils.equals((CharSequence)type.toUpperCase(), (CharSequence)"INTEGER")) {
            str = "jdbcType=INTEGER";
        }
        if (StringUtils.equals((CharSequence)type.toUpperCase(), (CharSequence)"DOUBLE")) {
            str = "jdbcType=DOUBLE";
        }
        if (StringUtils.equals((CharSequence)type.toUpperCase(), (CharSequence)"FLOAT")) {
            str = "jdbcType=FLOAT";
        }
        return str;
    }
}

