/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.util;

import cn.gtmap.realestate.common.core.ex.AppException;
import cn.gtmap.realestate.common.util.DataParseUtils;
import cn.gtmap.realestate.common.util.TokenUtils;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class RestRpcUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestRpcUtils.class);
    @Autowired
    private DiscoveryClient discoveryClient;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private TokenUtils tokenUtils;

    public <T> T getRpcRequest(String appName, String url, Map<String, Object> params) {
        if (StringUtils.isBlank((CharSequence)appName) || StringUtils.isBlank((CharSequence)url)) {
            throw new AppException("\u6267\u884cGET\u65b9\u5f0f\u8bf7\u6c42RPC\u8c03\u7528\u53d1\u751f\u9519\u8bef\uff0c\u539f\u56e0\uff1a\u672a\u5b9a\u4e49\u5e94\u7528\u540d\u79f0\u6216\u8bf7\u6c42URL\u5730\u5740\uff01");
        }
        try {
            String requestUrl = this.resolveRequestUrl(appName, url, params);
            RestTemplate template = this.getRestTemplate(appName);
            String result = (String)template.getForObject(requestUrl, String.class, new Object[0]);
            return (T)DataParseUtils.parseType(result);
        }
        catch (Exception e) {
            LOGGER.error("\u6267\u884cGET\u65b9\u5f0f\u8bf7\u6c42RPC\u8c03\u7528\u53d1\u751f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new AppException("\u6267\u884cGET\u65b9\u5f0f\u8bf7\u6c42RPC\u8c03\u7528\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    private String resolveRequestUrl(String appName, String url, Map<String, Object> params) throws URISyntaxException {
        if (MapUtils.isEmpty(params)) {
            return url;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            url = url.replaceAll("#\\{" + entry.getKey() + "\\}", String.valueOf(entry.getValue()));
        }
        url = new URIBuilder(url).addParameter("access_token", this.tokenUtils.getAccessToken()).build().toString();
        return "http://" + appName.trim() + url.trim();
    }

    public RestTemplate getRestTemplate(String appName) {
        List servicesList = this.discoveryClient.getServices();
        if (CollectionUtils.isNotEmpty((Collection)servicesList)) {
            for (String service : servicesList) {
                if (!StringUtils.equals((CharSequence)service, (CharSequence)appName)) continue;
                return this.restTemplate;
            }
        }
        return new RestTemplate();
    }
}

