/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.stereotype.Service;

@Service
public class RedisUtils<E> {
    private static final String NO_FOUND_KEY = "\u8bf7\u6c42key\u4e3a\u7a7a\uff01";
    private RedisTemplate redisTemplate;
    @Autowired
    private RedisConnectionFactory redisConnectionFactory;

    @PostConstruct
    public void setRedisKeySerializer() {
        this.redisTemplate = new RedisTemplate();
        this.redisTemplate.setConnectionFactory(this.redisConnectionFactory);
        this.redisTemplate.afterPropertiesSet();
        StringRedisSerializer stringSerializer = new StringRedisSerializer();
        this.redisTemplate.setKeySerializer((RedisSerializer)stringSerializer);
        this.redisTemplate.setValueSerializer((RedisSerializer)stringSerializer);
        this.redisTemplate.setHashKeySerializer((RedisSerializer)stringSerializer);
        this.redisTemplate.setHashValueSerializer((RedisSerializer)stringSerializer);
    }

    public String addSetValue(String key, Collection collection, long timeout) {
        if (StringUtils.isBlank((CharSequence)key) || CollectionUtils.isEmpty((Collection)collection)) {
            throw new NullPointerException("Redis\u65b0\u589eSet\u7c7b\u578b\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        this.redisTemplate.opsForSet().add((Object)key, collection.toArray());
        this.redisTemplate.expire((Object)key, timeout, TimeUnit.SECONDS);
        return key;
    }

    public Set<E> getSetValue(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new NullPointerException(NO_FOUND_KEY);
        }
        return this.redisTemplate.opsForSet().members((Object)key);
    }

    public void deleteKey(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new NullPointerException(NO_FOUND_KEY);
        }
        this.redisTemplate.delete((Object)key);
    }

    public String addStringValue(String key, String value, long timeout) {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new NullPointerException(NO_FOUND_KEY);
        }
        this.redisTemplate.opsForValue().set((Object)key, (Object)value);
        this.redisTemplate.expire((Object)key, timeout, TimeUnit.SECONDS);
        return key;
    }

    public String setStringValue(String key, String value) {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new NullPointerException(NO_FOUND_KEY);
        }
        this.redisTemplate.opsForValue().set((Object)key, (Object)value);
        this.redisTemplate.persist((Object)key);
        return key;
    }

    public String addStringValue(String key, String value) {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new NullPointerException(NO_FOUND_KEY);
        }
        this.redisTemplate.opsForValue().set((Object)key, (Object)value);
        return key;
    }

    public String getStringValue(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new NullPointerException(NO_FOUND_KEY);
        }
        Object value = this.redisTemplate.opsForValue().get((Object)key);
        return value == null ? null : String.valueOf(value);
    }

    public String addHashValue(String key, String hashkey, String value, long timeout) {
        if (StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)hashkey)) {
            throw new NullPointerException(NO_FOUND_KEY);
        }
        this.redisTemplate.opsForHash().put((Object)key, (Object)hashkey, (Object)value);
        this.redisTemplate.expire((Object)key, timeout, TimeUnit.SECONDS);
        return key;
    }

    public String addHashValue(String key, String hashkey, String value) {
        if (StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)hashkey)) {
            throw new NullPointerException(NO_FOUND_KEY);
        }
        this.redisTemplate.opsForHash().put((Object)key, (Object)hashkey, (Object)value);
        return key;
    }

    public String getHashValue(String key, String hashkey) {
        if (StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)hashkey)) {
            throw new NullPointerException(NO_FOUND_KEY);
        }
        return String.valueOf(this.redisTemplate.opsForHash().get((Object)key, (Object)hashkey));
    }

    public Long getIncrementValue(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new NullPointerException(NO_FOUND_KEY);
        }
        return this.redisTemplate.opsForValue().increment((Object)key, 1L);
    }

    public boolean isExistKey(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return false;
        }
        return this.redisTemplate.hasKey((Object)key);
    }

    public Set<String> getHashKeySet(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return Collections.emptySet();
        }
        return this.redisTemplate.opsForHash().keys((Object)key);
    }

    public Boolean isExistHashKey(String key, String hashkey) {
        if (StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)hashkey)) {
            return false;
        }
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)hashkey);
    }

    public Boolean addZsetKey(String key, String value, Double score) {
        if (StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)value) || null == score) {
            return false;
        }
        return this.redisTemplate.opsForZSet().add((Object)key, (Object)value, score.doubleValue());
    }

    public Set getZsetValue(String key, double start, double end) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return Collections.emptySet();
        }
        return this.redisTemplate.opsForZSet().rangeByScore((Object)key, start, end);
    }

    public void deleteHashValue(String key, String hashkey) {
        if (StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)hashkey)) {
            throw new NullPointerException(NO_FOUND_KEY);
        }
        this.redisTemplate.opsForHash().delete((Object)key, new Object[]{hashkey});
    }

    public Map<Object, Object> getHash(String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new NullPointerException(NO_FOUND_KEY);
        }
        return this.redisTemplate.opsForHash().entries((Object)key);
    }
}

