/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.util;

import cn.gtmap.realestate.common.core.domain.BdcQl;
import cn.gtmap.realestate.common.core.domain.BdcQlrDO;
import cn.gtmap.realestate.common.core.ex.AppException;
import cn.gtmap.realestate.common.core.qo.init.BdcYwxxDTO;
import cn.gtmap.realestate.common.core.support.mybatis.utils.AnnotationsUtils;
import cn.gtmap.realestate.common.util.RSAEncryptUtils;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class LogCompareUtils {
    private LogCompareUtils() {
    }

    public static Map<String, Object> initData(String xmid, BdcYwxxDTO bdcYwxxDTOBefore, BdcYwxxDTO bdcYwxxDTOAfter) throws Exception {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("after", RSAEncryptUtils.encrypt(JSON.toJSONString((Object)bdcYwxxDTOAfter)));
        data.put("before", RSAEncryptUtils.encrypt(JSON.toJSONString((Object)bdcYwxxDTOBefore)));
        data.put("paramCha", xmid);
        String change = LogCompareUtils.change(bdcYwxxDTOBefore, bdcYwxxDTOAfter, xmid);
        data.put("change", RSAEncryptUtils.encrypt(change));
        data.put("viewTypeName", "\u4fe1\u606f\u8865\u5f55\u66f4\u65b0\u4fe1\u606f");
        data.put("eventName", "XXBL");
        return data;
    }

    public static String change(BdcYwxxDTO ywxxBefore, BdcYwxxDTO ywxxAfter, String xmid) throws Exception {
        Field[] fields = BdcYwxxDTO.class.getDeclaredFields();
        StringBuilder change = new StringBuilder();
        for (Field field : fields) {
            field.setAccessible(true);
            Object objBefore = field.get(ywxxBefore);
            Object objAfter = field.get(ywxxAfter);
            if (objAfter == null && objBefore == null) continue;
            String objName = LogCompareUtils.getFieldName(field);
            if (field.getType() != List.class) {
                change.append(LogCompareUtils.compareNull(objBefore, objAfter, xmid, objName));
                continue;
            }
            List beforelist = (List)objBefore;
            List afterlist = (List)objAfter;
            if (CollectionUtils.isEmpty((Collection)beforelist) || CollectionUtils.isEmpty((Collection)afterlist)) {
                change.append(LogCompareUtils.compareNull(beforelist, afterlist, xmid, objName));
                continue;
            }
            HashMap beforeMap = Maps.newHashMap();
            Method keyMethod = AnnotationsUtils.getAnnotationsName(afterlist.get(0));
            for (Object e : beforelist) {
                String id = keyMethod.invoke(e, new Object[0]).toString();
                if (StringUtils.isBlank((String)id)) {
                    throw new AppException(objName + "\u4e3b\u952e\u4e22\u5931\u5f02\u5e38");
                }
                beforeMap.put(id, e);
            }
            for (Object e : afterlist) {
                String afterid = keyMethod.invoke(e, new Object[0]).toString();
                Object temp = beforeMap.get(afterid);
                if (temp == null) {
                    change.append("\u5217\u8868\u4e2d\u65b0\u589e id \u4e3a ").append(afterid).append(" \u7684").append(objName).append("\u5bf9\u8c61\n");
                    continue;
                }
                change.append(LogCompareUtils.compare(beforeMap.get(afterid), e));
                beforeMap.remove(afterid);
            }
            if (beforeMap.size() <= 0) continue;
            for (Map.Entry entry : beforeMap.entrySet()) {
                change.append("\u5217\u8868\u4e2d\u5220\u9664 id \u4e3a ").append((String)entry.getKey()).append(" \u7684").append(objName).append("\u5bf9\u8c61\n");
            }
        }
        return change.toString();
    }

    private static String compareNull(Object before, Object after, String xmid, String objName) throws Exception {
        String change = before == null ? "\u3010\u6570\u636e\u9879\u3011\u65b0\u589e " + objName + "\uff0c\u9879\u76ee id \u4e3a\uff1a" + xmid + "\n" : (after == null ? "\u3010\u6570\u636e\u9879\u3011\u5220\u9664 " + objName + "\u6570\u636e\uff0c\u9879\u76ee id \u4e3a\uff1a" + xmid + "\n" : LogCompareUtils.compare(before, after));
        return change;
    }

    private static String compare(Object before, Object after) throws Exception {
        Field[] fields;
        StringBuilder result = new StringBuilder();
        for (Field field : fields = before.getClass().getDeclaredFields()) {
            String afterStr;
            field.setAccessible(true);
            Object objBefore = field.get(before);
            Object objAfter = field.get(after);
            String beforeStr = objBefore == null ? "\u7a7a" : objBefore.toString();
            String string = afterStr = objAfter == null ? "\u7a7a" : objAfter.toString();
            if (StringUtils.equals((String)afterStr, (String)beforeStr)) continue;
            String value = LogCompareUtils.getFieldName(field);
            result.append(value).append(" \u7531\uff1a").append(beforeStr).append(" \u4fee\u6539\u4e3a\uff1a").append(afterStr).append("\uff1b\n");
        }
        if (StringUtils.isNotBlank((String)result.toString())) {
            return LogCompareUtils.getClassName(before) + ":\n" + result.toString();
        }
        return "";
    }

    public static String getFieldName(Field field) {
        String fieldName = field.getName();
        ApiModelProperty apiModelProperty = field.getAnnotation(ApiModelProperty.class);
        if (apiModelProperty != null && StringUtils.isNotBlank((String)apiModelProperty.value())) {
            fieldName = apiModelProperty.value();
        }
        return fieldName;
    }

    public static String getClassName(Object object) {
        ApiModel apiModelProperty;
        String className = object.getClass().getSimpleName();
        if (object instanceof BdcQl) {
            className = "\u6743\u5229\u4fe1\u606f";
        }
        if ((apiModelProperty = object.getClass().getAnnotation(ApiModel.class)) != null && StringUtils.isNotBlank((String)apiModelProperty.description())) {
            className = apiModelProperty.description();
        }
        if (object instanceof BdcQlrDO) {
            className = ((BdcQlrDO)object).getQlrmc();
        }
        return className;
    }
}

