/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.util;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageToPdf {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageToPdf.class);

    public static File Pdf(ArrayList<String> imageUrllist, String mOutputPdfFileName) {
        Document doc = new Document(PageSize.A4, 20.0f, 20.0f, 20.0f, 20.0f);
        try {
            PdfWriter.getInstance((Document)doc, (OutputStream)new FileOutputStream(mOutputPdfFileName));
            doc.open();
            for (int i = 0; i < imageUrllist.size(); ++i) {
                doc.newPage();
                Image png1 = Image.getInstance((String)imageUrllist.get(i));
                float heigth = png1.getHeight();
                float width = png1.getWidth();
                int percent = ImageToPdf.getPercent(heigth, width);
                png1.setAlignment(1);
                png1.scalePercent((float)percent);
                doc.add((Element)png1);
            }
            doc.close();
        }
        catch (FileNotFoundException e) {
            LOGGER.error("\u6587\u4ef6\u672a\u627e\u5230:{}", (Throwable)e);
        }
        catch (DocumentException e) {
            LOGGER.error("\u6587\u4ef6\u5939\u672a\u627e\u5230:{}", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("IO\u5f02\u5e38:{}", (Throwable)e);
        }
        File mOutputPdfFile = new File(mOutputPdfFileName);
        if (!mOutputPdfFile.exists()) {
            mOutputPdfFile.deleteOnExit();
            return null;
        }
        return mOutputPdfFile;
    }

    public static int getPercent(float h, float w) {
        int p = 0;
        float p2 = 0.0f;
        p2 = h > w ? 240.0f / h * 100.0f : 160.0f / w * 100.0f;
        p = Math.round(p2);
        return p;
    }

    public static int getPercent2(float h, float w) {
        int p = 0;
        float p2 = 0.0f;
        p2 = 530.0f / w * 100.0f;
        p = Math.round(p2);
        return p;
    }

    public static void imgOfPdf(String filepath, HttpServletRequest request) {
        boolean result = false;
        try {
            ArrayList<String> imageUrllist = new ArrayList<String>();
            imageUrllist.add(filepath);
            String fles = filepath.substring(0, filepath.lastIndexOf("."));
            String pdfUrl = fles + ".pdf";
            File file = ImageToPdf.Pdf(imageUrllist, pdfUrl);
            if (file != null) {
                file.createNewFile();
            }
        }
        catch (IOException e) {
            LOGGER.error("IO\u5f02\u5e38:{}", (Throwable)e);
        }
    }

    public static float mmTopx(float mm) {
        mm = (float)((double)mm * 3.33);
        return mm;
    }
}

