/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.util;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.Query;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IPPortUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(IPPortUtils.class);
    private static final String SPLIT = ":";
    private static final String PROTOCOL_HTTP = "http://";

    public static String getLocalPort() throws MalformedObjectNameException {
        MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> objectNames = beanServer.queryNames(new ObjectName("*:type=Connector,*"), Query.match(Query.attr("protocol"), Query.value("HTTP/1.1")));
        return objectNames.iterator().next().getKeyProperty("port");
    }

    public static String getLocalIP() {
        StringBuilder ipAddrStr = new StringBuilder();
        InetAddress addr = null;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            LOGGER.error("\u672a\u77e5\u7684\u57df\u540d", (Throwable)e);
        }
        if (null != addr) {
            byte[] ipAddr = addr.getAddress();
            for (int i = 0; i < ipAddr.length; ++i) {
                if (i > 0) {
                    ipAddrStr = ipAddrStr.append(".");
                }
                ipAddrStr = ipAddrStr.append(ipAddr[i] & 0xFF);
            }
        }
        return ipAddrStr.toString();
    }

    public static String serverPath() {
        String ipAddrStr = IPPortUtils.getLocalIP();
        String port = null;
        try {
            port = IPPortUtils.getLocalPort();
        }
        catch (MalformedObjectNameException e) {
            LOGGER.error("\u7aef\u53e3\u83b7\u53d6\u5f02\u5e38\uff01", (Throwable)e);
        }
        if (StringUtils.isNotBlank((CharSequence)ipAddrStr) && StringUtils.isNotBlank((CharSequence)port)) {
            return PROTOCOL_HTTP + ipAddrStr + SPLIT + port;
        }
        return null;
    }

    public static String getClientIp(HttpServletRequest request) {
        String ip;
        block8: {
            ip = "";
            if (request == null) break block8;
            ip = request.getHeader("X-Forwarded-For");
            try {
                block10: {
                    block9: {
                        if (ip != null && ip.length() != 0 && !"unknown".equalsIgnoreCase(ip)) break block9;
                        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                            ip = request.getHeader("Proxy-Client-IP");
                        }
                        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                            ip = request.getHeader("WL-Proxy-Client-IP");
                        }
                        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                            ip = request.getHeader("HTTP_CLIENT_IP");
                        }
                        if (ip != null && ip.length() != 0 && !"unknown".equalsIgnoreCase(ip)) break block10;
                        ip = request.getHeader("HTTP_X_FORWARDED_FOR");
                        break block10;
                    }
                    if (ip.length() > 15) {
                        String[] ips = ip.split(",");
                        for (int index = 0; index < ips.length; ++index) {
                            String strIp = ips[index];
                            if ("unknown".equalsIgnoreCase(strIp)) continue;
                            ip = strIp;
                            break;
                        }
                    }
                }
                if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                    ip = request.getRemoteAddr();
                }
            }
            catch (Exception e) {
                LOGGER.error(null, (Throwable)e);
            }
        }
        return ip;
    }
}

