/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.util;

import cn.gtmap.realestate.common.core.annotations.Zd;
import cn.gtmap.realestate.common.core.cache.BdcZdCache;
import cn.gtmap.realestate.common.core.dto.BdcMapZdConvertDTO;
import cn.gtmap.realestate.common.core.service.Impl.BdcZdGlServiceImpl;
import cn.gtmap.realestate.common.core.support.mybatis.utils.AnnotationsUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Import;
import org.springframework.stereotype.Service;

@Service(value="entityZdConvertUtils")
@Import(value={BdcZdCache.class, BdcZdGlServiceImpl.class})
public class EntityZdConvertUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityZdConvertUtils.class);
    private static final String CONVERTTOMC = "mc";
    private static final String CONVERTTODM = "dm";
    @Autowired
    BdcZdCache bdcZdCache;

    public void convertEntityToMc(Object entity) {
        this.convertEntity(entity, false, null, CONVERTTOMC);
    }

    public void convertEntityToMc(Object entity, Boolean isCoverNullField, String[] convertfieldList) {
        this.convertEntity(entity, isCoverNullField, convertfieldList, CONVERTTOMC);
    }

    public void convertEntityToDm(Object entity) {
        this.convertEntity(entity, false, null, CONVERTTODM);
    }

    public void convertEntityToDm(Object entity, Boolean isCoverNullField, String[] convertfieldList) {
        this.convertEntity(entity, isCoverNullField, convertfieldList, CONVERTTODM);
    }

    private void convertEntity(Object entity, Boolean isCoverNullField, String[] convertfieldList, String convertTo) {
        List<Field> fieldList = AnnotationsUtils.getAnnotationField(entity, Zd.class);
        Boolean isConvertAll = ArrayUtils.isEmpty((Object[])convertfieldList);
        if (CollectionUtils.isNotEmpty(fieldList)) {
            for (Field entityField : fieldList) {
                Object value;
                if (!isConvertAll.booleanValue() && !ArrayUtils.contains((Object[])convertfieldList, (Object)entityField.getName())) continue;
                Zd entityFieldId = entityField.getAnnotation(Zd.class);
                String table = entityFieldId.table();
                String dm = entityFieldId.dm();
                String mc = entityFieldId.mc();
                Class tableClass = entityFieldId.tableClass();
                if (StringUtils.isBlank((CharSequence)table)) {
                    table = tableClass.getSimpleName();
                }
                if (!StringUtils.isNotBlank((CharSequence)table) || EntityZdConvertUtils.getEntityFieldValue(entityField, entity) == null || (value = StringUtils.equals((CharSequence)convertTo, (CharSequence)CONVERTTOMC) ? this.bdcZdCache.getFeildValue(table, EntityZdConvertUtils.getEntityFieldValue(entityField, entity), mc, dm, tableClass) : this.bdcZdCache.getFeildValue(table, EntityZdConvertUtils.getEntityFieldValue(entityField, entity), dm, mc, tableClass)) == null && !isCoverNullField.booleanValue()) continue;
                EntityZdConvertUtils.setEntityFieldValue(entityField, entity, value);
            }
        }
    }

    private static Object getEntityFieldValue(Field entityField, Object entity) {
        if (entityField != null && entity != null) {
            try {
                StringBuilder sb = new StringBuilder();
                sb.append("get");
                sb.append(entityField.getName().substring(0, 1).toUpperCase());
                sb.append(entityField.getName().substring(1));
                Method method = entity.getClass().getMethod(sb.toString(), new Class[0]);
                return method.invoke(entity, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.error("\u83b7\u53d6\u503c\u65f6\u62a5\u9519", (Throwable)e);
            }
        }
        return null;
    }

    private static void setEntityFieldValue(Field entityField, Object entity, Object value) {
        if (entityField != null && entity != null) {
            try {
                Class[] parameterTypes = new Class[]{entityField.getType()};
                StringBuilder sb = new StringBuilder();
                sb.append("set");
                sb.append(entityField.getName().substring(0, 1).toUpperCase());
                sb.append(entityField.getName().substring(1));
                Method method = entity.getClass().getMethod(sb.toString(), parameterTypes);
                method.invoke(entity, value);
            }
            catch (Exception e) {
                LOGGER.error("\u8d4b\u503c\u65f6\u62a5\u9519", (Throwable)e);
            }
        }
    }

    public void convertMapToMc(Map convertMap) {
        this.convertMap(convertMap, false, CONVERTTOMC, BdcZdCache.defaultConvertVoList);
    }

    public void convertMapToMc(Map convertMap, List<BdcMapZdConvertDTO> convertVoList) {
        this.convertMap(convertMap, false, CONVERTTOMC, convertVoList);
    }

    public void convertMapToMc(Map convertMap, Boolean isCoverNullField, List<BdcMapZdConvertDTO> convertVoList) {
        this.convertMap(convertMap, isCoverNullField, CONVERTTOMC, convertVoList);
    }

    public void convertMapToDm(Map convertMap) {
        this.convertMap(convertMap, false, CONVERTTODM, BdcZdCache.defaultConvertVoList);
    }

    public void convertMapToDm(Map convertMap, List<BdcMapZdConvertDTO> convertVoList) {
        this.convertMap(convertMap, false, CONVERTTODM, convertVoList);
    }

    public void convertMapToDm(Map convertMap, Boolean isCoverNullField, List<BdcMapZdConvertDTO> convertVoList) {
        this.convertMap(convertMap, isCoverNullField, CONVERTTODM, convertVoList);
    }

    private void convertMap(Map convertMap, Boolean isCoverNullField, String convertTo, List<BdcMapZdConvertDTO> convertVoList) {
        if (CollectionUtils.isNotEmpty(convertVoList)) {
            for (BdcMapZdConvertDTO convertVo : convertVoList) {
                Object value;
                String fieldName = convertMap.containsKey(StringUtils.upperCase((String)convertVo.getName())) ? StringUtils.upperCase((String)convertVo.getName()) : StringUtils.lowerCase((String)convertVo.getName());
                String fieldValue = MapUtils.getString((Map)convertMap, (Object)fieldName);
                if (!StringUtils.isNotBlank((CharSequence)fieldValue) || (value = StringUtils.equals((CharSequence)convertTo, (CharSequence)CONVERTTOMC) ? this.bdcZdCache.getFeildValue(convertVo.getTable(), fieldValue, convertVo.getMc(), convertVo.getDm(), convertVo.getTableClass()) : this.bdcZdCache.getFeildValue(convertVo.getTable(), fieldValue, convertVo.getDm(), convertVo.getMc(), convertVo.getTableClass())) == null && !isCoverNullField.booleanValue()) continue;
                convertMap.put(fieldName, value);
            }
        }
    }
}

