/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateUtils.class);
    public static final String sdf_China = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String sdf = "yyyy-MM-dd";
    public static final String sdf_ymd = "yyyyMMdd";
    public static final String sdf_ymdWithSpilt = "yyyy/MM/dd";
    public static final String sdf_ymdhms = "yyyy-MM-dd hh:mm:ss";
    private static final DateTimeFormatter DATE_FORMATYMDHMS = DateTimeFormatter.ofPattern("yyyyMMddHHmmss", Locale.CHINA);
    private static final DateTimeFormatter DATE_FORMATYMD = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5", Locale.CHINA);
    private static final DateTimeFormatter DATE_FORMATYMDHMS_SPLIT = DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm:ss", Locale.CHINA);

    public static Date dealDate(Date date, String time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(sdf);
        String dateStr = dateFormat.format(date) + " " + time;
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat(sdf_ymdhms);
        Date resultDate = null;
        try {
            resultDate = dateTimeFormat.parse(dateStr);
        }
        catch (ParseException e) {
            LOGGER.error(null, (Throwable)e);
        }
        return resultDate;
    }

    public static String formateTime(Date date, DateTimeFormatter dateTimeFormatter) {
        LocalDateTime localDateTime = DateUtils.date2LocalDateTime(date);
        return localDateTime.format(dateTimeFormatter);
    }

    public static String formateTimeYmdhms(Date date) {
        LocalDateTime localDateTime = DateUtils.date2LocalDateTime(date);
        return localDateTime.format(DATE_FORMATYMDHMS);
    }

    public static String formateYmdZw(Date date) {
        LocalDateTime localDateTime = DateUtils.date2LocalDateTime(date);
        return localDateTime.format(DATE_FORMATYMD);
    }

    public static String formateYmdhms(Date date) {
        LocalDateTime localDateTime = DateUtils.date2LocalDateTime(date);
        return localDateTime.format(DATE_FORMATYMDHMS_SPLIT);
    }

    public static Date formatDate(String str) {
        Date date = null;
        try {
            if (StringUtils.isNotBlank((String)str)) {
                date = new SimpleDateFormat(sdf).parse(str);
            }
        }
        catch (Exception e) {
            LOGGER.info("\u65e5\u671f\u8f6c\u6362\u5931\u8d25\uff1a{}", (Object)str);
            try {
                date = new SimpleDateFormat(sdf_ymd).parse(str);
            }
            catch (ParseException e1) {
                LOGGER.info("\u65e5\u671f\u8f6c\u6362\u5931\u8d25\uff1a{}", (Object)str);
                try {
                    date = new SimpleDateFormat(sdf_China).parse(str);
                }
                catch (ParseException e2) {
                    LOGGER.info("\u65e5\u671f\u8f6c\u6362\u5931\u8d25\uff1a{}", (Object)str);
                    try {
                        date = new SimpleDateFormat(sdf_ymdWithSpilt).parse(str);
                    }
                    catch (ParseException e3) {
                        LOGGER.info("\u65e5\u671f\u8f6c\u6362\u5931\u8d25\uff1a{}", (Object)str);
                        return null;
                    }
                }
            }
        }
        return date;
    }

    public static Date formatDate(String str, String pattern) {
        Date date = null;
        try {
            if (StringUtils.isNotBlank((String)str)) {
                date = new SimpleDateFormat(pattern).parse(str);
            }
        }
        catch (ParseException e) {
            LOGGER.info("", (Throwable)e);
        }
        return date;
    }

    public static LocalDateTime date2LocalDateTime(Date date) {
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        return instant.atZone(zoneId).toLocalDateTime();
    }

    public static int getSeason(Date date) {
        int season = 0;
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int month = c.get(2);
        switch (month) {
            case 0: 
            case 1: 
            case 2: {
                season = 1;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                season = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                season = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                season = 4;
                break;
            }
        }
        return season;
    }

    public static long getDayTimeOfZeroHMS(Date date) {
        if (null == date) {
            return -1L;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime().getTime();
    }

    public static long getDayTimeOfLastHMS(Date date) {
        if (null == date) {
            return -1L;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime().getTime();
    }
}

