/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtilForWorkDay {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateUtilForWorkDay.class);
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    public static boolean isLawHoliday(String calendar, List<String> holidayList) throws Exception {
        DateUtilForWorkDay.isValidDate(calendar);
        return holidayList.contains(calendar);
    }

    public static boolean isWeekends(String calendar) throws Exception {
        DateUtilForWorkDay.isValidDate(calendar);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = sdf.parse(calendar);
        Calendar ca = Calendar.getInstance();
        ca.setTime(date);
        return ca.get(7) == 7 || ca.get(7) == 1;
    }

    public static boolean isExtraWorkday(String calendar, List<String> workdayList) throws Exception {
        DateUtilForWorkDay.isValidDate(calendar);
        return workdayList.contains(calendar);
    }

    public static boolean isHoliday(String calendar, List<String> holidayList, List<String> workdayList) throws Exception {
        DateUtilForWorkDay.isValidDate(calendar);
        if (DateUtilForWorkDay.isLawHoliday(calendar, holidayList)) {
            return true;
        }
        if (!DateUtilForWorkDay.isWeekends(calendar)) {
            return false;
        }
        return !DateUtilForWorkDay.isExtraWorkday(calendar, workdayList);
    }

    private static boolean isValidDate(String str) {
        boolean convertSuccess = true;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            format.setLenient(false);
            format.parse(str);
        }
        catch (ParseException e) {
            convertSuccess = false;
        }
        return convertSuccess;
    }

    public static Date getNextWorkDay(Date date, int num, List<String> holidayList, List<String> workdayList) throws Exception {
        Date tomorrow = null;
        int delay = 1;
        while (delay <= num) {
            tomorrow = DateUtilForWorkDay.getTomorrow(date);
            if (!DateUtilForWorkDay.isHoliday(sdf.format(tomorrow), holidayList, workdayList)) {
                ++delay;
                date = tomorrow;
                continue;
            }
            date = tomorrow;
        }
        return date;
    }

    public static Date getTomorrow(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        date = calendar.getTime();
        return date;
    }
}

