/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.util;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class DataParseUtils {
    private static final String REGEX_NUMBER = "[0-9]+";
    private static final String BOOLEAN_CAP_TRUE = "TRUE";
    private static final String BOOLEAN_CAP_FALSE = "FALSE";
    private static final String BOOLEAN_LOW_TRUE = "true";
    private static final String BOOLEAN_LOW_FALSE = "false";

    public static <T> Object parseType(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return null;
        }
        if (str.matches(REGEX_NUMBER)) {
            return Integer.parseInt(str);
        }
        if (BOOLEAN_CAP_TRUE.equals(str) || BOOLEAN_CAP_FALSE.equals(str) || BOOLEAN_LOW_TRUE.equals(str) || BOOLEAN_LOW_FALSE.equals(str)) {
            return Boolean.parseBoolean(str);
        }
        try {
            return new Gson().fromJson(str, new TypeToken<List<T>>(){}.getType());
        }
        catch (Exception exception) {
            try {
                return new Gson().fromJson(str, new TypeToken<List<String>>(){}.getType());
            }
            catch (Exception exception2) {
                try {
                    return new Gson().fromJson(str, new TypeToken<List<Integer>>(){}.getType());
                }
                catch (Exception exception3) {
                    try {
                        return new Gson().fromJson(str, new TypeToken<List<Map>>(){}.getType());
                    }
                    catch (Exception exception4) {
                        try {
                            return new Gson().fromJson(str, new TypeToken<Map>(){}.getType());
                        }
                        catch (Exception exception5) {
                            return str;
                        }
                    }
                }
            }
        }
    }
}

