/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.util;

import cn.gtmap.realestate.common.core.ex.AppException;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;

public class CommonUtil {
    public static String formatEmptyValue(Object object) {
        return object != null ? object.toString() : "";
    }

    public static String getCurrStrDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String str = sdf.format(new Date());
        return str;
    }

    public static String ternaryOperator(Object object) {
        return object != null ? object.toString() : "";
    }

    public static String ternaryOperatorNotBlank(Object object) {
        String str = CommonUtil.ternaryOperator(object);
        return StringUtils.isNotBlank((CharSequence)str) ? str : "/";
    }

    public static String ternaryOperator(Object object, String defaultValue) {
        String str = object != null ? object.toString() : CommonUtil.ternaryOperator(defaultValue);
        return StringUtils.isNotBlank((CharSequence)str) ? str : CommonUtil.ternaryOperator(defaultValue);
    }

    public static <T> T ternaryOperator(Object object, Object defaultValue) {
        return (T)(object != null ? object : defaultValue);
    }

    public static int getDisplayTimes(String str, String s) {
        int count = str.length() - str.replace(s, "").length();
        return count;
    }

    public static int getCharacterPosition(String string, String s, int psition) {
        Matcher slashMatcher = Pattern.compile(s).matcher(string);
        int mIdx = 0;
        while (slashMatcher.find() && ++mIdx != psition) {
        }
        return slashMatcher.start();
    }

    public static <T> T cast(Object obj) {
        return (T)obj;
    }

    public static boolean indexOfStrs(String[] a, String b) {
        boolean msg = false;
        if (a != null) {
            for (String temp : a) {
                if (!StringUtils.equals((CharSequence)temp, (CharSequence)b)) continue;
                msg = true;
                break;
            }
        }
        return msg;
    }

    public static boolean equalsExcatTrueIgnoreCase(String str) {
        return StringUtils.equalsIgnoreCase((CharSequence)str, (CharSequence)String.valueOf(Boolean.TRUE));
    }

    public static boolean equalsExcatFalseIgnoreCase(String str) {
        return StringUtils.equalsIgnoreCase((CharSequence)str, (CharSequence)String.valueOf(Boolean.FALSE));
    }

    public static String removeDuplicateStr(String str, String splitStr) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            String[] strs = str.split(splitStr);
            StringBuilder finalStr = new StringBuilder();
            for (int i = 0; i < strs.length; ++i) {
                set.add(strs[i]);
            }
            for (Object strTemp : set.toArray()) {
                if (finalStr.length() > 0) {
                    finalStr.append(splitStr);
                }
                finalStr.append(strTemp.toString());
            }
            return finalStr.toString();
        }
        return CommonUtil.ternaryOperator(str);
    }

    public static Map<String, Object> removeEmptyParam(Map<String, Object> param, String ... exceptions) {
        Iterator<Map.Entry<String, Object>> it = param.entrySet().iterator();
        HashMap<String, Object> newParam = new HashMap<String, Object>();
        List<Object> exceptionList = new ArrayList();
        if (exceptions != null) {
            exceptionList = Arrays.asList(exceptions);
        }
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            if (StringUtils.isNotBlank((CharSequence)String.valueOf(entry.getValue())) && !exceptionList.contains(String.valueOf(entry.getKey()))) {
                newParam.put(String.valueOf(entry.getKey()), StringUtils.deleteWhitespace((String)String.valueOf(entry.getValue())));
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)String.valueOf(entry.getValue())) || !exceptionList.contains(String.valueOf(entry.getKey()))) continue;
            newParam.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
        }
        return newParam;
    }

    public static Map<String, List> seperateBigListSamllList(List list, int sizeLimit) {
        return CommonUtil.seperateBigListSamllList(list, sizeLimit, "list");
    }

    public static Map<String, List> seperateBigListSamllList(List list, int sizeLimit, String prefix) {
        LinkedHashMap<String, List> map = new LinkedHashMap<String, List>();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            int size = CollectionUtils.size((Object)list);
            int times = size / sizeLimit + (size % sizeLimit > 0 ? 1 : 0);
            for (int i = 0; i < times; ++i) {
                map.put(prefix + i, list.subList(i * sizeLimit, (i + 1) * sizeLimit < size ? (i + 1) * sizeLimit : size));
            }
        }
        return map;
    }

    public static String getUrlParameters(String url, String para) {
        if (StringUtils.isBlank((CharSequence)url) || StringUtils.isBlank((CharSequence)para)) {
            return null;
        }
        String paraStr = url.contains("?") ? url.substring(url.indexOf("?") + 1) : "";
        String[] paraArr = StringUtils.split((String)paraStr, (String)"&");
        if (paraArr.length > 0) {
            for (int i = 0; i < paraArr.length; ++i) {
                String[] p = StringUtils.split((String)paraArr[i], (String)"=");
                if (p.length <= 0 || !StringUtils.equals((CharSequence)p[0], (CharSequence)para)) continue;
                return p[1];
            }
        }
        return null;
    }

    public static String conbineQueryCondition(String keyId, Map<String, List> param) {
        StringBuilder sql = new StringBuilder("(");
        int i = 0;
        for (String key : param.keySet()) {
            if (i > 0) {
                sql.append(" or");
            }
            sql.append(keyId).append(" in (:").append(key).append(")");
            ++i;
        }
        sql.append(")");
        return sql.toString();
    }

    public static Map<String, List<Map<String, Object>>> divideListToMap(String keyId, List<Map<String, Object>> list) {
        LinkedHashMap<String, List<Map<String, Object>>> map = new LinkedHashMap<String, List<Map<String, Object>>>();
        if (CollectionUtils.isNotEmpty(list)) {
            for (Map<String, Object> row : list) {
                String keyValue = CommonUtil.ternaryOperator(row.get(keyId));
                List tempList = (List)CommonUtil.ternaryOperator(map.get(keyValue), new ArrayList());
                tempList.add(row);
                map.put(keyValue, tempList);
            }
        }
        return map;
    }

    public static void deleteLastComma(StringBuilder param) {
        if (param != null && param.indexOf(",") != -1) {
            param.deleteCharAt(param.lastIndexOf(","));
        }
    }

    public static void copyFieldValue(Object source, Object dest, List<String> sourceFiledName, List<String> destFieldName) {
        if (source == null) {
            throw new AppException("\u590d\u5236\u5c5e\u6027\u51fa\u9519\uff1a\u6e90\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (dest == null) {
            throw new AppException("\u590d\u5236\u5c5e\u6027\u51fa\u9519\uff1a\u76ee\u6807\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(sourceFiledName) || CollectionUtils.isEmpty(destFieldName)) {
            throw new AppException("\u590d\u5236\u5c5e\u6027\u51fa\u9519\uff1a\u672a\u6307\u5b9a\u590d\u5236\u5c5e\u6027");
        }
        if (sourceFiledName.size() != destFieldName.size()) {
            throw new AppException("\u590d\u5236\u5c5e\u6027\u51fa\u9519\uff1a\u590d\u5236\u4e2a\u6570\u4e0d\u5339\u914d, \u6e90\u5bf9\u8c61\u5c5e\u6027\u4e2a\u6570:" + sourceFiledName.size() + ", \u76ee\u6807\u5bf9\u8c61\u5c5e\u6027\u4e2a\u6570:" + destFieldName.size());
        }
        Method getMethod = null;
        Method setMethod = null;
        String getMethodName = null;
        String setMethodName = null;
        Field sourceField = null;
        Field destField = null;
        Object value = null;
        for (int i = 0; i < sourceFiledName.size(); ++i) {
            try {
                sourceField = source.getClass().getDeclaredField(sourceFiledName.get(i));
            }
            catch (NoSuchFieldException e) {
                throw new AppException("\u590d\u5236\u5c5e\u6027\u51fa\u9519\uff1a\u6e90\u5bf9\u8c61\u4e2d\u65e0\u5c5e\u6027: " + destFieldName.get(i));
            }
            try {
                destField = dest.getClass().getDeclaredField(destFieldName.get(i));
            }
            catch (NoSuchFieldException e) {
                throw new AppException("\u590d\u5236\u5c5e\u6027\u51fa\u9519\uff1a\u76ee\u6807\u5bf9\u8c61\u4e2d\u65e0\u5c5e\u6027: " + destFieldName.get(i));
            }
            if (!sourceField.getType().equals(destField.getType())) {
                throw new AppException("\u590d\u5236\u5c5e\u6027\u51fa\u9519\uff1a\u5c5e\u6027\u7c7b\u578b\u4e0d\u540c: " + sourceFiledName.get(i));
            }
            getMethodName = String.format("get%s%s", sourceFiledName.get(i).substring(0, 1).toUpperCase(), sourceFiledName.get(i).substring(1));
            setMethodName = String.format("set%s%s", destFieldName.get(i).substring(0, 1).toUpperCase(), destFieldName.get(i).substring(1));
            try {
                getMethod = source.getClass().getMethod(getMethodName, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new AppException("\u590d\u5236\u5c5e\u6027\u51fa\u9519\uff1a\u6e90\u5bf9\u8c61\u65e0\u65b9\u6cd5: " + getMethodName);
            }
            try {
                setMethod = dest.getClass().getMethod(setMethodName, destField.getType());
            }
            catch (NoSuchMethodException e) {
                throw new AppException("\u590d\u5236\u5c5e\u6027\u51fa\u9519\uff1a\u76ee\u6807\u5bf9\u8c61\u65e0\u65b9\u6cd5: " + setMethodName);
            }
            try {
                value = getMethod.invoke(source, new Object[0]);
                if (value == null) continue;
                setMethod.invoke(dest, value);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new AppException("\u590d\u5236\u5c5e\u6027\u51fa\u9519\uff1a" + e);
            }
            catch (InvocationTargetException e) {
                throw new AppException("\u590d\u5236\u5c5e\u6027\u51fa\u9519\uff1a" + e);
            }
        }
    }

    public static Map<String, List<String>> splitKeyList(List<String> sourceList, String defaultKey, String separate) {
        HashMap result = Maps.newHashMap();
        String[] strings = null;
        String key = null;
        String value = null;
        if (CollectionUtils.isNotEmpty(sourceList)) {
            separate = StringUtils.isNotEmpty((CharSequence)separate) ? separate : ",";
            defaultKey = StringUtils.isNotEmpty((CharSequence)defaultKey) ? defaultKey : "normal";
            for (String str : sourceList) {
                strings = StringUtils.splitByWholeSeparator((String)str, (String)separate);
                if (strings.length > 1) {
                    key = strings[0];
                    value = strings[1];
                } else {
                    key = defaultKey;
                    value = strings[0];
                }
                if (!result.containsKey(key)) {
                    result.put(key, Lists.newArrayList());
                }
                ((List)result.get(key)).add(value);
            }
        }
        return result;
    }

    public static boolean isJSONObject(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return false;
        }
        try {
            JSONObject.parseObject((String)text);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isJSONOArray(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return false;
        }
        try {
            JSONArray.parseArray((String)text);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static int getNumberByStr(String str) {
        if ((str = str.trim()).length() == 0) {
            return 0;
        }
        int flag = 1;
        int rev = 0;
        int edge = 0xCCCCCCC;
        if (str.charAt(0) == '-') {
            flag = -1;
            str = str.substring(1, str.length());
        } else if (str.charAt(0) == '+') {
            str = str.substring(1, str.length());
        } else if (str.charAt(0) < '0' || str.charAt(0) > '9') {
            return 0;
        }
        for (char s : str.toCharArray()) {
            if (s < '0' || s > '9') break;
            int n = s - 48;
            if (rev >= edge) {
                if (flag == 1) {
                    if (rev > edge || n > 7) {
                        return Integer.MAX_VALUE;
                    }
                } else if (rev > edge || n > 8) {
                    return Integer.MIN_VALUE;
                }
            }
            rev = rev * 10 + n;
        }
        return rev * flag;
    }

    public static <T> T getOrElse(T obj, T defaultObj) {
        return Optional.ofNullable(obj).orElse(defaultObj);
    }

    public static <T> T getOrElse(T obj, Predicate<T> condition, T defaultObj) {
        return Optional.ofNullable(obj).filter(condition).orElse(defaultObj);
    }
}

