/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.util;

import cn.gtmap.realestate.common.util.AnnotationsUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CheckParameter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckParameter.class);

    private CheckParameter() {
    }

    public static Boolean checkAnyParameter(Object checkData, String ... paramNames) {
        if (checkData == null) {
            return false;
        }
        Class<?> checkClass = checkData.getClass();
        try {
            ArrayList<Field> fieldList = new ArrayList<Field>();
            AnnotationsUtils.getClassFields(checkClass, fieldList);
            if (CollectionUtils.isNotEmpty(fieldList)) {
                for (Field field : fieldList) {
                    field.setAccessible(true);
                    if (StringUtils.equals((CharSequence)"serialVersionUID", (CharSequence)field.getName()) || field.get(checkData) == null || paramNames.length != 0 && !ArrayUtils.contains((Object[])paramNames, (Object)field.getName())) continue;
                    return true;
                }
            }
        }
        catch (IllegalAccessException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
        return false;
    }

    public static Boolean checkAllParameter(Object checkData) {
        if (checkData == null) {
            return false;
        }
        Class<?> checkClass = checkData.getClass();
        try {
            Field[] fields;
            for (Field field : fields = checkClass.getDeclaredFields()) {
                field.setAccessible(true);
                if (field.get(checkData) != null) continue;
                return false;
            }
        }
        catch (IllegalAccessException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
        return true;
    }

    public static Boolean checkPartElementsNotAllExist(Object obj, Collection<Object> exceptElements) {
        if (null == obj) {
            return true;
        }
        Class<?> checkClass = obj.getClass();
        try {
            Field[] fields;
            for (Field field : fields = checkClass.getDeclaredFields()) {
                if (CollectionUtils.isNotEmpty(exceptElements) && exceptElements.contains(field.getName())) continue;
                field.setAccessible(true);
                if (null == field.get(obj)) continue;
                return false;
            }
        }
        catch (IllegalAccessException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
        return true;
    }

    public static Boolean checkAppointedElementsAllNotExist(Object obj, Collection<Object> elements) {
        if (null == obj) {
            return true;
        }
        Class<?> checkClass = obj.getClass();
        try {
            Field[] fields;
            for (Field field : fields = checkClass.getDeclaredFields()) {
                if (!CollectionUtils.isNotEmpty(elements) || !elements.contains(field.getName())) continue;
                field.setAccessible(true);
                if (null == field.get(obj)) continue;
                return false;
            }
        }
        catch (IllegalAccessException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
        return true;
    }
}

