/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.util;

import cn.gtmap.realestate.common.core.annotations.RequiredFk;
import cn.gtmap.realestate.common.util.AnnotationsUtils;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Id;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckEntityUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckEntityUtils.class);

    public static boolean checkPkAndFk(Object entityClass) {
        List<Field> fieldPkList = AnnotationsUtils.getAnnotationField(entityClass, Id.class);
        List<Field> fieldFkList = AnnotationsUtils.getAnnotationField(entityClass, RequiredFk.class);
        boolean pk = CheckEntityUtils.checkObjectNotNull(fieldPkList, entityClass);
        boolean fk = CheckEntityUtils.checkObjectNotNull(fieldFkList, entityClass);
        return pk && fk;
    }

    public static boolean checkPk(Object entityClass) {
        List<Field> fieldPkList = AnnotationsUtils.getAnnotationField(entityClass, Id.class);
        boolean pk = CheckEntityUtils.checkObjectNotNull(fieldPkList, entityClass);
        return pk;
    }

    public static Map<String, Object> getPkValue(Object entity) {
        List<Field> fieldPkList = AnnotationsUtils.getAnnotationField(entity, Id.class);
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : fieldPkList) {
            map.put(field.getName(), CheckEntityUtils.getFieldValue(field, entity));
        }
        return map;
    }

    public static boolean checkFk(Object entityClass) {
        List<Field> fieldFkList = AnnotationsUtils.getAnnotationField(entityClass, RequiredFk.class);
        boolean fk = CheckEntityUtils.checkObjectNotNull(fieldFkList, entityClass);
        return fk;
    }

    private static boolean checkObjectNotNull(List<Field> list, Object entityClass) {
        for (Field field : list) {
            Object value = CheckEntityUtils.getFieldValue(field, entityClass);
            if (value == null) {
                return false;
            }
            if (!(value instanceof String) || !StringUtils.isBlank((CharSequence)value.toString())) continue;
            return false;
        }
        return true;
    }

    public static Object getFieldValue(Field field, Object entityClass) {
        Object value = null;
        String key = field.getName();
        PropertyDescriptor descriptor = null;
        try {
            descriptor = new PropertyDescriptor(key, entityClass.getClass());
            Method method = descriptor.getReadMethod();
            if (method != null) {
                value = method.invoke(entityClass, new Object[0]);
            }
        }
        catch (IntrospectionException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return value;
    }
}

