/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.util;

import cn.gtmap.realestate.common.core.ex.AppException;
import java.util.regex.Pattern;

public class ChangeMoneyToCnUtils {
    private static final Pattern AMOUNT_PATTERN = Pattern.compile("^(0|[1-9]\\d{0,11})\\.(\\d\\d)$");
    private static final char[] RMB_NUMS = "\u96f6\u58f9\u8d30\u53c1\u8086\u4f0d\u9646\u67d2\u634c\u7396".toCharArray();
    private static final String[] UNITS = new String[]{"\u5143", "\u89d2", "\u5206", "\u6574"};
    private static final String[] U1 = new String[]{"", "\u62fe", "\u4f70", "\u4edf"};
    private static final String[] U2 = new String[]{"", "\u4e07", "\u4ebf"};

    public static String convert(String money) throws Exception {
        String decimalData;
        boolean lessZero = false;
        if (money.startsWith("-")) {
            money = money.substring(1);
            lessZero = true;
        }
        if (!money.matches("^[0-9]*$|^0+\\.[0-9]+$|^[1-9]+[0-9]*$|^[1-9]+[0-9]*.[0-9]+$")) {
            throw new AppException("\u91d1\u94b1\u683c\u5f0f\u9519\u8bef\uff01");
        }
        String[] part = money.split("\\.");
        String integerData = part[0];
        String string = decimalData = part.length > 1 ? part[1] : "";
        if (integerData.matches("^0+$")) {
            integerData = "0";
        } else if (integerData.matches("^0+(\\d+)$")) {
            integerData = integerData.replaceAll("^0+(\\d+)$", "$1");
        }
        StringBuilder integer = new StringBuilder();
        for (int i = 0; i < integerData.length(); ++i) {
            char perchar = integerData.charAt(i);
            integer.append(ChangeMoneyToCnUtils.upperNumber(perchar));
            integer.append(ChangeMoneyToCnUtils.upperNumber(integerData.length() - i - 1));
        }
        StringBuilder decimal = new StringBuilder();
        if (part.length > 1 && !"00".equals(decimalData)) {
            int length = decimalData.length() >= 2 ? 2 : decimalData.length();
            for (int i = 0; i < length; ++i) {
                char perchar = decimalData.charAt(i);
                decimal.append(ChangeMoneyToCnUtils.upperNumber(perchar));
                if (i == 0) {
                    decimal.append('\u89d2');
                }
                if (i != 1) continue;
                decimal.append('\u5206');
            }
        }
        String result = integer.toString() + decimal.toString();
        result = ChangeMoneyToCnUtils.dispose(result);
        if (lessZero && !"\u96f6\u5706\u6574".equals(result)) {
            result = "\u8d1f" + result;
        }
        return result;
    }

    private static char upperNumber(char number) {
        switch (number) {
            case '0': {
                return '\u96f6';
            }
            case '1': {
                return '\u58f9';
            }
            case '2': {
                return '\u8d30';
            }
            case '3': {
                return '\u53c1';
            }
            case '4': {
                return '\u8086';
            }
            case '5': {
                return '\u4f0d';
            }
            case '6': {
                return '\u9646';
            }
            case '7': {
                return '\u67d2';
            }
            case '8': {
                return '\u634c';
            }
            case '9': {
                return '\u7396';
            }
        }
        return '0';
    }

    private static char upperNumber(int index) {
        int realIndex = index % 9;
        if (index > 8) {
            realIndex = (index - 9) % 8;
            ++realIndex;
        }
        switch (realIndex) {
            case 0: {
                return '\u5706';
            }
            case 1: {
                return '\u62fe';
            }
            case 2: {
                return '\u4f70';
            }
            case 3: {
                return '\u4edf';
            }
            case 4: {
                return '\u4e07';
            }
            case 5: {
                return '\u62fe';
            }
            case 6: {
                return '\u4f70';
            }
            case 7: {
                return '\u4edf';
            }
            case 8: {
                return '\u4ebf';
            }
        }
        return '0';
    }

    private static String dispose(String result) {
        result = result.replaceAll("0", "");
        result = result.replaceAll("\u96f6\u4edf\u96f6\u4f70\u96f6\u62fe|\u96f6\u4edf\u96f6\u4f70|\u96f6\u4f70\u96f6\u62fe|\u96f6\u4edf|\u96f6\u4f70|\u96f6\u62fe", "\u96f6");
        result = (result = result.replaceAll("\u96f6+", "\u96f6").replace("\u96f6\u4ebf", "\u4ebf")).matches("^.*\u4ebf\u96f6\u4e07[^\u96f6]\u4edf.*$") ? result.replace("\u96f6\u4e07", "\u96f6") : result.replace("\u96f6\u4e07", "\u4e07");
        result = result.replace("\u4ebf\u4e07", "\u4ebf");
        result = result.replace("\u96f6\u89d2", "\u96f6").replace("\u96f6\u5206", "");
        result = result.replaceAll("(^[\u96f6\u5706]*)(.+$)", "$2");
        result = result.replaceAll("(^.*)([\u96f6]+\u5706)(.+$)", "$1\u5706\u96f6$3");
        result = result.replaceAll("\u5706\u96f6\u89d2\u96f6\u5206|\u5706\u96f6\u89d2$|\u5706$|^\u96f6$|\u5706\u96f6$|\u96f6\u5706$", "\u5706\u6574");
        result = result.replaceAll("^\u5706\u6574$", "\u96f6\u5706\u6574");
        return result;
    }

    public static String moneyFormat(String money) {
        StringBuilder sb = new StringBuilder();
        if (money == null) {
            return "0.00";
        }
        int index = money.indexOf(".");
        if (index == -1) {
            return money + ".00";
        }
        String s0 = money.substring(0, index);
        String s1 = money.substring(index + 1);
        if (s1.length() == 1) {
            s1 = s1 + "0";
        } else if (s1.length() > 2) {
            s1 = s1.substring(0, 2);
        }
        sb.append(s0);
        sb.append(".");
        sb.append(s1);
        return sb.toString();
    }
}

