/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.util;

import org.apache.commons.lang.StringUtils;

public class CardNumberTransformation {
    private CardNumberTransformation() {
    }

    public static String idCard15to18(String idCard) {
        idCard = idCard.trim();
        StringBuilder idCard18 = new StringBuilder(idCard);
        char[] checkBit = new char[]{'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
        int sum = 0;
        if (idCard != null && idCard.length() == 15) {
            idCard18.insert(6, "19");
            for (int index = 0; index < idCard18.length(); ++index) {
                char c = idCard18.charAt(index);
                int ai = Integer.parseInt(Character.toString(c));
                int wi = (int)Math.pow(2.0, idCard18.length() - index) % 11;
                sum += ai * wi;
            }
            int indexOfCheckBit = sum % 11;
            idCard18.append(checkBit[indexOfCheckBit]);
        }
        return idCard18.toString();
    }

    public static String idCard18to15(String zjh) {
        String zjh15 = "";
        if (zjh.length() == 18) {
            zjh15 = zjh.substring(0, 6) + zjh.substring(8, 17);
        }
        return zjh15;
    }

    public static boolean idCard15(String zjh) {
        String regex15 = "^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}$";
        return zjh.length() == 15 && zjh.matches(regex15);
    }

    public static boolean idCard18(String zjh) {
        String regex18 = "^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$";
        return zjh.length() == 18 && zjh.matches(regex18);
    }

    public static boolean isTyshxydm18(String license) {
        if (StringUtils.isEmpty((String)license)) {
            return false;
        }
        if (license.length() != 18) {
            return false;
        }
        String regex = "^([159Y]{1})([1239]{1})([0-9ABCDEFGHJKLMNPQRTUWXY]{6})([0-9ABCDEFGHJKLMNPQRTUWXY]{9})([0-90-9ABCDEFGHJKLMNPQRTUWXY])$";
        if (!license.matches(regex)) {
            return false;
        }
        String str = "0123456789ABCDEFGHJKLMNPQRTUWXY";
        int[] ws = new int[]{1, 3, 9, 27, 19, 26, 16, 17, 20, 29, 25, 13, 8, 24, 10, 30, 28};
        String[] codes = new String[]{license.substring(0, license.length() - 1), license.substring(license.length() - 1, license.length())};
        int sum = 0;
        for (int i = 0; i < 17; ++i) {
            sum += str.indexOf(codes[0].charAt(i)) * ws[i];
        }
        int c18 = 31 - sum % 31;
        if (c18 == 31) {
            c18 = 89;
        } else if (c18 == 30) {
            c18 = 48;
        }
        return str.charAt(c18) == codes[1].charAt(0);
    }

    public static boolean isTyshxydm15(String license) {
        if (StringUtils.isEmpty((String)license)) {
            return false;
        }
        if (license.length() != 15) {
            return false;
        }
        String businesslicensePrex14 = license.substring(0, 14);
        String businesslicense15 = license.substring(14, license.length());
        char[] chars = businesslicensePrex14.toCharArray();
        int[] ints = new int[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            ints[i] = Integer.parseInt(String.valueOf(chars[i]));
        }
        CardNumberTransformation.getCheckCode(ints);
        return businesslicense15.equals(CardNumberTransformation.getCheckCode(ints) + "");
    }

    public static int getCheckCode(int[] ints) {
        if (null != ints && ints.length > 1) {
            int ti = 0;
            int si = 0;
            int cj = 0;
            int pj = 10;
            for (int i = 0; i < ints.length; ++i) {
                ti = ints[i];
                pj = cj % 11 == 0 ? 10 : cj % 11;
                si = pj + ti;
                cj = (0 == si % 10 ? 10 : si % 10) * 2;
                if (i != ints.length - 1) continue;
                pj = cj % 11 == 0 ? 10 : cj % 11;
                return pj == 1 ? 1 : 11 - pj;
            }
        }
        return -1;
    }

    public static String zjhTransformation(String zjh) {
        String regex15 = "^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}$";
        String regex18 = "^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$";
        if (zjh.length() == 15) {
            if (zjh.matches(regex15)) {
                String zjh18 = CardNumberTransformation.idCard15to18(zjh);
                zjh = zjh + "," + zjh18;
                return StringUtils.upperCase((String)zjh);
            }
            return StringUtils.upperCase((String)zjh);
        }
        if (zjh.length() == 18) {
            if (zjh.matches(regex18)) {
                String zjh15 = CardNumberTransformation.idCard18to15(zjh);
                zjh = zjh15 + "," + zjh;
                return StringUtils.upperCase((String)zjh);
            }
            return StringUtils.upperCase((String)zjh);
        }
        return StringUtils.upperCase((String)zjh);
    }
}

