/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class BeansResolveUtils
implements ApplicationContextAware {
    private static SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final Logger LOGGER = LoggerFactory.getLogger(BeansResolveUtils.class);
    private static final String CLASS_NAME = BeansResolveUtils.class.getName();
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) {
        if (null == this.applicationContext) {
            this.applicationContext = applicationContext;
        }
    }

    public <T> T getBeanByName(String name) {
        if (null == this.applicationContext || StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        return (T)this.applicationContext.getBean(name);
    }

    public <T> T getBeanOfMapItem(Map<Object, String> beansNameMap, Object key) {
        if (MapUtils.isEmpty(beansNameMap) || StringUtils.isBlank((CharSequence)String.valueOf(key))) {
            LOGGER.warn("{}\uff1a\u83b7\u53d6\u914d\u7f6e\u9879Bean\u96c6\u5408\u5931\u8d25\uff0c\u539f\u56e0\u53ef\u80fd\uff1a\u5165\u53c2Bean\u540d\u79f0\u96c6\u5408\u4e3a\u7a7a\u3001\u672a\u6307\u5b9a\u8981\u83b7\u53d6bean\u5bf9\u5e94\u7684\u952e\u503c\uff01", (Object)CLASS_NAME);
            return null;
        }
        String beanName = MapUtils.getString(beansNameMap, (Object)key);
        return this.getBeanByName(beanName);
    }

    public <T> List<T> listBeans(List<String> beansNameList) {
        if (CollectionUtils.isEmpty(beansNameList)) {
            LOGGER.warn("{}\uff1a\u83b7\u53d6\u914d\u7f6e\u9879Bean\u96c6\u5408\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5165\u53c2Bean\u540d\u79f0\u96c6\u5408\u4e3a\u7a7a\uff01", (Object)CLASS_NAME);
            return Collections.emptyList();
        }
        ArrayList<T> beansList = new ArrayList<T>(beansNameList.size());
        for (String beanName : beansNameList) {
            if (!StringUtils.isNotBlank((CharSequence)beanName)) continue;
            T bean = this.getBeanByName(beanName);
            if (null == bean) {
                LOGGER.warn("{}\uff1a\u83b7\u53d6\u914d\u7f6e\u9879Bean\u96c6\u5408\u4e2d\u6b62\uff0c\u539f\u56e0\uff1a\u672a\u627e\u5230{}\u5bf9\u5e94bean\uff01", (Object)CLASS_NAME, (Object)beanName);
                continue;
            }
            beansList.add(bean);
        }
        return beansList;
    }

    public <T> Map<Object, T> listBeansOfMapType(Map<Object, String> beansNameMap) {
        if (MapUtils.isEmpty(beansNameMap)) {
            LOGGER.warn("{}\uff1a\u83b7\u53d6\u914d\u7f6e\u9879Bean\u96c6\u5408\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5165\u53c2Bean\u540d\u79f0\u96c6\u5408\u4e3a\u7a7a\uff01", (Object)CLASS_NAME);
            return Collections.emptyMap();
        }
        HashMap<Object, T> beansMap = new HashMap<Object, T>(beansNameMap.size());
        for (Map.Entry<Object, String> entry : beansNameMap.entrySet()) {
            if (!StringUtils.isNotBlank((CharSequence)entry.getValue())) continue;
            T bean = this.getBeanByName(entry.getValue());
            if (null == bean) {
                LOGGER.warn("{}\uff1a\u83b7\u53d6\u914d\u7f6e\u9879Bean\u96c6\u5408\u4e2d\u6b62\uff0c\u539f\u56e0\uff1a\u672a\u627e\u5230{}\u5bf9\u5e94bean\uff01", (Object)CLASS_NAME, (Object)entry.getValue());
                continue;
            }
            beansMap.put(entry.getKey(), bean);
        }
        return beansMap;
    }

    public static void clonePropertiesValue(Object originObject, Object targetObject) {
        Field[] originFields = originObject.getClass().getDeclaredFields();
        List<String> originFieldsNameList = BeansResolveUtils.getClassFieldsName(originFields);
        Field[] targetFields = targetObject.getClass().getDeclaredFields();
        try {
            for (Field targetField : targetFields) {
                if (!originFieldsNameList.contains(targetField.getName())) continue;
                Field originField = originObject.getClass().getDeclaredField(targetField.getName());
                originField.setAccessible(true);
                Object value = originField.get(originObject);
                if (!StringUtils.isNotBlank((CharSequence)String.valueOf(value))) continue;
                targetField.setAccessible(true);
                targetField.set(targetObject, value);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void clonePropsValueWithParentProps(Object originObject, Object targetObject) {
        Field[] originFields = originObject.getClass().getDeclaredFields();
        List<String> originFieldsNameList = BeansResolveUtils.getClassFieldsName(originFields);
        Object[] targetFields = targetObject.getClass().getDeclaredFields();
        Object[] parentFields = targetObject.getClass().getSuperclass().getDeclaredFields();
        targetFields = (Field[])ArrayUtils.addAll((Object[])targetFields, (Object[])parentFields);
        try {
            for (Object targetField : targetFields) {
                if (!originFieldsNameList.contains(((Field)targetField).getName())) continue;
                Field originField = originObject.getClass().getDeclaredField(((Field)targetField).getName());
                originField.setAccessible(true);
                Object value = originField.get(originObject);
                if (!StringUtils.isNotBlank((CharSequence)String.valueOf(value))) continue;
                ((Field)targetField).setAccessible(true);
                ((Field)targetField).set(targetObject, value);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public static List<String> getClassFieldsName(Field[] fields) {
        if (null == fields || 0 == fields.length) {
            return Collections.emptyList();
        }
        ArrayList<String> fieldsNameList = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            if (null == field) continue;
            fieldsNameList.add(field.getName());
        }
        return fieldsNameList;
    }

    public static <T> String toNotNullPropertyListJSON(List<T> list) throws IllegalAccessException {
        if (CollectionUtils.isEmpty(list)) {
            return "";
        }
        JSONArray jsonArray = new JSONArray(list.size());
        for (T object : list) {
            Field[] fields;
            JSONObject jsonObject = new JSONObject();
            for (Field field : fields = object.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                Object obj = field.get(object);
                if (null == obj || !StringUtils.isNotBlank((CharSequence)String.valueOf(obj))) continue;
                if (obj instanceof Object[]) {
                    jsonObject.put(field.getName(), (Object)StringUtils.join((Object[])((Object[])obj), (String)","));
                    continue;
                }
                if (obj instanceof Date) {
                    jsonObject.put(field.getName(), (Object)formatter.format((Date)obj));
                    continue;
                }
                jsonObject.put(field.getName(), (Object)String.valueOf(obj));
            }
            jsonArray.add((Object)jsonObject);
        }
        return JSON.toJSONString((Object)jsonArray);
    }

    public static <T> String toNotNullPropertyJSON(T object) throws IllegalAccessException {
        Field[] fields;
        if (null == object) {
            return "";
        }
        JSONObject jsonObject = new JSONObject();
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            Object obj = field.get(object);
            if (null == obj || !StringUtils.isNotBlank((CharSequence)String.valueOf(obj))) continue;
            if (obj instanceof Object[]) {
                jsonObject.put(field.getName(), (Object)StringUtils.join((Object[])((Object[])obj), (String)","));
                continue;
            }
            if (obj instanceof Date) {
                jsonObject.put(field.getName(), (Object)formatter.format((Date)obj));
                continue;
            }
            jsonObject.put(field.getName(), (Object)String.valueOf(obj));
        }
        return JSON.toJSONString((Object)jsonObject);
    }
}

