/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.util;

import cn.gtmap.realestate.common.util.BASE64DecodedMultipartFile;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import sun.misc.BASE64Decoder;

public class Base64Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Base64Utils.class);

    public static MultipartFile base64ToMultipart(String base64) {
        try {
            String[] baseStrs = base64.split(",");
            if (baseStrs.length > 1) {
                BASE64Decoder decoder = new BASE64Decoder();
                byte[] b = decoder.decodeBuffer(baseStrs[1]);
                for (int i = 0; i < b.length; ++i) {
                    if (b[i] >= 0) continue;
                    int n = i;
                    b[n] = (byte)(b[n] + 256);
                }
                return new BASE64DecodedMultipartFile(b, baseStrs[0]);
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    public static String encodeByteToBase64Str(byte[] bytes) {
        String base64Str = "";
        if (null != bytes) {
            base64Str = Base64.encodeBase64String((byte[])bytes);
        }
        return base64Str;
    }

    public static byte[] decodeBase64StrToByte(String base64Str) {
        byte[] bytes = null;
        if (StringUtils.isNotBlank((CharSequence)base64Str)) {
            bytes = Base64.decodeBase64((String)base64Str);
        }
        return bytes;
    }

    public static boolean decodeBase64StrToFile(String base64Str, String filePath) {
        String path;
        byte[] bytes = Base64Utils.decodeBase64StrToByte(base64Str);
        return null != bytes && StringUtils.isNotBlank((CharSequence)(path = Base64Utils.byteToFile(filePath, bytes)));
    }

    public static String byteToFile(String filePath, byte[] file) {
        try {
            FileUtils.writeByteArrayToFile((File)new File(filePath), (byte[])file);
            return filePath;
        }
        catch (IOException e) {
            LOGGER.error("byteToFile", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void changeBase64ToImage(String imageStr, String filename, String formatName, HttpServletResponse response) {
        response.setContentType("image/jpeg");
        response.setDateHeader("expries", -1L);
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        response.addHeader("Content-Disposition", "attachment; filename=" + filename);
        ByteArrayInputStream bis = null;
        try {
            byte[] bytes = Base64Utils.decodeBase64StrToByte(imageStr);
            bis = new ByteArrayInputStream(bytes);
            BufferedImage image = ImageIO.read(bis);
            int width = (int)((double)image.getWidth(null) * 0.5);
            int height = (int)((double)image.getHeight(null) * 0.5);
            BufferedImage bufferImage = new BufferedImage(width, height, 1);
            bufferImage.getGraphics().drawImage(image, 0, 0, width, height, image.getGraphics().getColor(), null);
            ImageIO.write((RenderedImage)bufferImage, formatName, (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            LOGGER.error("\u56fe\u50cf\u8f6c\u6362\u5f02\u5e38\uff01", (Throwable)e);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    LOGGER.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void base64StringToPdf(String base64Content, String filePath) {
        BASE64Decoder decoder = new BASE64Decoder();
        BufferedInputStream bin = null;
        FileOutputStream fout = null;
        FilterOutputStream bout = null;
        try {
            byte[] bytes = decoder.decodeBuffer(base64Content);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            bin = new BufferedInputStream(bais);
            File file = new File(filePath);
            fout = new FileOutputStream(file);
            bout = new BufferedOutputStream(fout);
            byte[] buffers = new byte[1024];
            int len = bin.read(buffers);
            while (len != -1) {
                ((BufferedOutputStream)bout).write(buffers, 0, len);
                len = bin.read(buffers);
            }
            ((BufferedOutputStream)bout).flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                bout.close();
                fout.close();
                bin.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

