/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.core.support.spring;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.servlet.DelegatingFilterProxyRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="html")
public class TsHtmlFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TsHtmlFilter.class);
    private String version;

    @Bean(value={"htmlFilter"})
    public Filter filter() {
        return new Filter(){

            public void init(FilterConfig filterConfig) throws ServletException {
                LOGGER.info("html filter init!");
            }

            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                ClassPathResource resource;
                String tspath;
                HttpServletRequest httpRequest = (HttpServletRequest)request;
                String path = httpRequest.getServletPath();
                if (StringUtils.isNotBlank((CharSequence)TsHtmlFilter.this.version) && path.indexOf("/" + TsHtmlFilter.this.version + "/") < 0 && !StringUtils.equals((CharSequence)(tspath = path.replaceFirst("view", TsHtmlFilter.this.version)), (CharSequence)path) && (resource = new ClassPathResource("/META-INF/resources" + tspath)).exists()) {
                    httpRequest.getRequestDispatcher(tspath).forward((ServletRequest)httpRequest, response);
                    return;
                }
                chain.doFilter(request, response);
            }

            public void destroy() {
            }
        };
    }

    @Bean
    public DelegatingFilterProxyRegistrationBean delegatingFilterProxyRegistrationBean() {
        DelegatingFilterProxyRegistrationBean bean = new DelegatingFilterProxyRegistrationBean("htmlFilter", new ServletRegistrationBean[0]);
        bean.addUrlPatterns(new String[]{"*.html"});
        return bean;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

