/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.core.support.spring;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.stereotype.Component;

@Component
public class InitYmlDataAfterRuner
implements ApplicationRunner {
    private static Logger logger = LoggerFactory.getLogger(InitYmlDataAfterRuner.class);
    @Autowired
    private RedisConnectionFactory redisConnectionFactory;
    @Autowired
    private ConfigurableEnvironment configurableEnvironment;
    @Value(value="${spring.config.location:}")
    public String springConfigLocation;

    public void run(ApplicationArguments args) throws Exception {
        logger.info("\u9879\u76ee\u542f\u52a8\u5b8c\u6210,\u5f00\u59cb\u6267\u884c\u521d\u59cb\u5316InitYmlDataAfterRuner\u4efb\u52a1...spring.config.location:{}", (Object)this.springConfigLocation);
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setConnectionFactory(this.redisConnectionFactory);
        redisTemplate.afterPropertiesSet();
        StringRedisSerializer stringSerializer = new StringRedisSerializer();
        redisTemplate.setKeySerializer((RedisSerializer)stringSerializer);
        redisTemplate.setValueSerializer((RedisSerializer)stringSerializer);
        MutablePropertySources mutablePropertySources = this.configurableEnvironment.getPropertySources();
        HashMap map = new HashMap();
        mutablePropertySources.forEach(propertySource -> {
            MapPropertySource mps;
            Map targetMap;
            if (propertySource instanceof MapPropertySource && propertySource.getName().startsWith("applicationConfig") && Objects.nonNull(targetMap = (Map)(mps = (MapPropertySource)propertySource).getSource())) {
                map.putAll(targetMap);
            }
        });
        logger.info("\u8bfb\u53d6\u5230\u7684\u914d\u7f6e\u5185\u5bb9: {}", (Object)JSON.toJSONString(map));
        if (Objects.nonNull(map)) {
            String value = (String)redisTemplate.opsForValue().get((Object)"REDIS_INIT_YML");
            if (StringUtils.isNotBlank((CharSequence)value)) {
                Map cacheMap = (Map)JSON.parse((String)value);
                cacheMap.putAll(map);
                redisTemplate.opsForValue().set((Object)"REDIS_INIT_YML", (Object)JSON.toJSONString((Object)cacheMap));
            } else {
                redisTemplate.opsForValue().set((Object)"REDIS_INIT_YML", (Object)JSON.toJSONString(map));
            }
        }
    }
}

