/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.core.support.spring;

import cn.gtmap.gtc.feign.common.exception.GtFeignException;
import cn.gtmap.realestate.common.core.enums.ExceptionMessageEnum;
import cn.gtmap.realestate.common.core.ex.AppException;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.AmqpException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class ControllerExceptionHandler {
    private static Logger logger = LoggerFactory.getLogger(ControllerExceptionHandler.class);
    private final ObjectMapper objectMapper;

    @Autowired
    public ControllerExceptionHandler(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @ExceptionHandler(value={Exception.class})
    public void getError(HttpServletResponse response, Exception ex) throws IOException {
        response.setContentType(ContentType.APPLICATION_JSON.toString());
        Integer errorCode = 1;
        StringBuilder errorMsgBuilder = new StringBuilder();
        if (ex instanceof IOException) {
            response.setStatus(HttpStatus.NOT_FOUND.value());
            errorCode = 8;
            errorMsgBuilder.append(ExceptionMessageEnum.IO_EX.getMessage());
        }
        if (ex instanceof AppException) {
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            if (((AppException)ex).getCode() != null) {
                errorCode = ((AppException)ex).getCode();
            }
            errorMsgBuilder.append(ex.getMessage());
        }
        if (ex instanceof ConstraintViolationException) {
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            errorCode = 55;
            for (ConstraintViolation violation : ((ConstraintViolationException)ex).getConstraintViolations()) {
                errorMsgBuilder.append(violation.getMessage());
            }
        }
        if (ex instanceof TimeoutException) {
            response.setStatus(HttpStatus.NOT_IMPLEMENTED.value());
            errorCode = 8;
            errorMsgBuilder.append(ExceptionMessageEnum.TIMEOUT_EX.getMessage());
        }
        if (ex instanceof BindException) {
            FieldError fieldError;
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            BindingResult bindingResult = ((BindException)ex).getBindingResult();
            if (bindingResult != null && bindingResult.getFieldError() != null && (fieldError = bindingResult.getFieldError()) != null) {
                errorCode = 55;
                errorMsgBuilder.append(fieldError.getDefaultMessage());
            }
            if (errorCode != 55) {
                response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
                errorMsgBuilder.append(ex.getMessage());
            }
        }
        GtFeignException gte = null;
        if (ex instanceof GtFeignException) {
            gte = (GtFeignException)ex;
        }
        if (ex.getCause() != null && ex.getCause() instanceof GtFeignException) {
            gte = (GtFeignException)ex.getCause();
        }
        if (gte != null) {
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            String responseBody = gte.getMsgBody();
            Map bodyMap = (Map)JSONObject.parseObject((String)responseBody, Map.class);
            if (MapUtils.getInteger((Map)bodyMap, (Object)"code") != null && StringUtils.isNotBlank((CharSequence)MapUtils.getString((Map)bodyMap, (Object)"msg"))) {
                errorCode = MapUtils.getInteger((Map)bodyMap, (Object)"code");
                errorMsgBuilder.append(MapUtils.getString((Map)bodyMap, (Object)"msg"));
            } else {
                errorCode = gte.getCode();
            }
        }
        if (ex instanceof DataAccessException || ex instanceof SQLException) {
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            errorCode = 10;
            errorMsgBuilder.append(ExceptionMessageEnum.DB_EX.getMessage());
        }
        if (ex instanceof AmqpException) {
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            errorCode = 80;
            errorMsgBuilder.append(ExceptionMessageEnum.MQ_EX.getMessage());
        }
        if (ex instanceof UnsupportedOperationException) {
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            errorCode = 6;
            errorMsgBuilder.append(ExceptionMessageEnum.UN_SUPPORT_EX.getMessage());
        }
        if (ex instanceof ClassNotFoundException || ex instanceof ClassCastException) {
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            errorCode = 7;
            errorMsgBuilder.append(ExceptionMessageEnum.CLASS_EX.getMessage());
        }
        if (StringUtils.isBlank((CharSequence)errorMsgBuilder.toString())) {
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            errorMsgBuilder.append(ExceptionMessageEnum.SERVER_EX.getMessage());
        }
        ArrayList exceptionDetail = Lists.newArrayList();
        exceptionDetail.add(ex.getMessage());
        if (ex.getCause() != null) {
            exceptionDetail.add(ex.getCause().getMessage());
        }
        logger.error(errorMsgBuilder.toString(), (Throwable)ex);
        ImmutableMap resultMap = new ImmutableMap.Builder().put((Object)"code", (Object)errorCode).put((Object)"msg", (Object)errorMsgBuilder).put((Object)"detail", (Object)exceptionDetail).build();
        this.objectMapper.writeValue((Writer)response.getWriter(), (Object)resultMap);
    }
}

