/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.core.support.pdf.service.impl.thread;

import cn.gtmap.realestate.common.core.support.pdf.service.OfficeDocService;
import cn.gtmap.realestate.common.util.UUIDGenerator;
import com.deepoove.poi.NiceXWPFDocument;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CountDownLatch;
import org.docx4j.Docx4J;
import org.docx4j.convert.out.FOSettings;
import org.docx4j.fonts.IdentityPlusMapper;
import org.docx4j.fonts.Mapper;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.fonts.PhysicalFonts;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.RFonts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfTask.class);
    private OfficeDocService officeDocService;
    private Map<String, Object> pdfData;
    private int index;
    private String printPath;
    private String modelName;
    private ConcurrentSkipListMap<String, String> pdfMap;
    private CountDownLatch countDownLatch;

    public PdfTask(OfficeDocService officeDocService, Map<String, Object> pdfData, int index, String modelName, String printPath, ConcurrentSkipListMap<String, String> pdfMap, CountDownLatch countDownLatch) {
        this.officeDocService = officeDocService;
        this.printPath = printPath;
        this.pdfData = pdfData;
        this.index = index;
        this.modelName = modelName;
        this.pdfMap = pdfMap;
        this.countDownLatch = countDownLatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LOGGER.debug("PDF\u5bfc\u51fa\u6b63\u5728\u5904\u7406\u7b2c{}\u4efd\u6587\u4ef6\uff01", (Object)this.countDownLatch.getCount());
        String tempWordFileName = this.generateWordFileName();
        String tempPdfFileName = this.generatePdfFileName();
        try {
            FileOutputStream wordFileOutStream = new FileOutputStream(new File(tempWordFileName));
            NiceXWPFDocument document = this.officeDocService.getNiceXWPFDocument(this.modelName, this.pdfData);
            document.write((OutputStream)wordFileOutStream);
            this.convertDocxToPDF(tempWordFileName, tempPdfFileName);
            this.pdfMap.put(String.valueOf(this.index), tempPdfFileName);
            LOGGER.debug("\u5f53\u524d\u5904\u7406\u7b2c{}\u9875\u6587\u6863\u5b8c\u6210", (Object)(this.index + 1));
        }
        catch (Exception e) {
            LOGGER.error("\u5904\u7406WORD\u8f6c\u6362\u4e3aPDF\u51fa\u9519\uff1a{}", (Object)e.getMessage());
        }
        finally {
            this.countDownLatch.countDown();
            File wordFile = new File(tempWordFileName);
            if (wordFile.exists()) {
                wordFile.delete();
            }
        }
    }

    private void convertDocxToPDF(String docxPath, String pdfPath) {
        try (FileOutputStream os = new FileOutputStream(pdfPath);){
            WordprocessingMLPackage mlPackage = WordprocessingMLPackage.load((InputStream)new FileInputStream(new File(docxPath)));
            this.configSimSunFont(mlPackage);
            FOSettings foSettings = Docx4J.createFOSettings();
            foSettings.setWmlPackage((OpcPackage)mlPackage);
            Docx4J.toFO((FOSettings)foSettings, (OutputStream)os, (int)1);
        }
        catch (Exception ex) {
            LOGGER.error("word\u8f6c\u4e3apdf\u51fa\u9519\uff0c{}", (Object)ex.getMessage());
        }
    }

    private void configSimSunFont(WordprocessingMLPackage wordMLPackage) throws Exception {
        String fontFamily = "SimSun";
        URL simsunUrl = new URL("file:" + this.printPath + "simsun.ttc");
        PhysicalFonts.addPhysicalFonts((String)fontFamily, (URL)simsunUrl);
        PhysicalFont simsunFont = PhysicalFonts.get((String)fontFamily);
        IdentityPlusMapper fontMapper = new IdentityPlusMapper();
        fontMapper.put(fontFamily, simsunFont);
        wordMLPackage.setFontMapper((Mapper)fontMapper);
        RFonts rfonts = Context.getWmlObjectFactory().createRFonts();
        rfonts.setAsciiTheme(null);
        rfonts.setAscii(fontFamily);
        wordMLPackage.getMainDocumentPart().getPropertyResolver().getDocumentDefaultRPr().setRFonts(rfonts);
    }

    private String generateWordFileName() {
        return this.printPath + "temp/" + UUIDGenerator.generate16() + ".docx";
    }

    private String generatePdfFileName() {
        return this.printPath + "temp/" + UUIDGenerator.generate16() + ".pdf";
    }
}

