/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.core.support.pdf.service.impl;

import cn.gtmap.realestate.common.core.dto.OfficeExportDTO;
import cn.gtmap.realestate.common.core.ex.AppException;
import cn.gtmap.realestate.common.core.support.pdf.service.OfficeDataService;
import cn.gtmap.realestate.common.core.support.pdf.service.OfficeDocService;
import cn.gtmap.realestate.common.core.support.pdf.service.OfficePdfService;
import cn.gtmap.realestate.common.core.support.pdf.service.impl.thread.PdfTask;
import cn.gtmap.realestate.common.util.UUIDGenerator;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OfficePdfServiceImpl
implements OfficePdfService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OfficePdfServiceImpl.class);
    @Value(value="${print.path:/usr/local/bdc3/print/}")
    private String printPath;
    @Autowired
    private OfficeDocService officeDocService;
    @Autowired
    private OfficeDataService officeDataService;
    private ExecutorService executor = new ThreadPoolExecutor(4, 6, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(200), new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    LOGGER.error("PDF\u5904\u7406\u7ebf\u7a0b\u53d1\u751f\u5f02\u5e38\uff1a{}", (Object)e.toString());
                }
            });
            return thread;
        }
    }, (task, executor) -> LOGGER.error("\u751f\u6210PDF\u4efb\u52a1\u88ab\u62d2\u7edd\uff0c\u8bf7\u68c0\u67e5\u5bfc\u51fa\u6570\u91cf\uff01"));

    @PostConstruct
    public void init() {
        File file = new File(this.printPath + "temp/");
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    @Override
    public String generatePdfFile(OfficeExportDTO officeExportDTO) {
        String string;
        block14: {
            ConcurrentSkipListMap<String, String> pdfMap = new ConcurrentSkipListMap<String, String>();
            try {
                List<Map<String, Object>> dataList = this.officeDataService.getValDataList(officeExportDTO.getXmlData());
                if (CollectionUtils.isEmpty(dataList)) {
                    String string2 = null;
                    return string2;
                }
                int dataSize = dataList.size();
                LOGGER.debug("\u5bfc\u51faPDF\u6587\u6863\uff1a{}\uff0c\u5171{}\u9875", (Object)officeExportDTO.getFileName(), (Object)dataSize);
                CountDownLatch countDownLatch = new CountDownLatch(dataSize);
                BlockingQueue<Runnable> queue = ((ThreadPoolExecutor)this.executor).getQueue();
                for (int index = 0; index < dataSize; ++index) {
                    int freeCount = queue.remainingCapacity();
                    if (freeCount <= 10) {
                        LOGGER.debug("\u5bfc\u51faPDF\u7ebf\u7a0b\u6c60\u961f\u5217\u5269\u4f59\u7a7a\u95f4\u8f83\u5c11\uff0c\u5f00\u59cb\u7b49\u5f85\u63d0\u4ea4\u4efb\u52a1\uff0c\u6587\u4ef6\u540d\uff1a{}", (Object)officeExportDTO.getFileName());
                        long start = System.currentTimeMillis();
                        do {
                            Thread.sleep(500L);
                        } while (queue.remainingCapacity() <= 10 || System.currentTimeMillis() - start < 5000L);
                    }
                    PdfTask pdfTask = new PdfTask(this.officeDocService, dataList.get(index), index, officeExportDTO.getModelName(), this.printPath, pdfMap, countDownLatch);
                    LOGGER.debug("\u5bfc\u51faPDF\u5904\u7406\u7b2c{}\u4e2a\u5b50\u4efb\u52a1\u63d0\u4ea4", (Object)(index + 1));
                    this.executor.submit(pdfTask);
                }
                boolean waitRes = countDownLatch.await(300L, TimeUnit.SECONDS);
                if (!waitRes) {
                    LOGGER.error("PDF\u5bfc\u51fa\u8d85\u65f65\u5206\u949f\uff0c\u5904\u7406\u7ec8\u6b62\uff0c\u76ee\u6807\u6587\u4ef6\uff1a{}", (Object)officeExportDTO.getFileName());
                    throw new AppException("PDF\u5bfc\u51fa\u8d85\u65f65\u5206\u949f\uff0c\u5904\u7406\u7ec8\u6b62");
                }
                LOGGER.debug("PDF\u5bfc\u51fa\u4e2d\u95f4\u4e34\u65f6\u6587\u4ef6\u5904\u7406\u5b8c\u6bd5\uff0c\u5f00\u59cb\u5408\u5e76\u6587\u4ef6:{}\uff01", (Object)officeExportDTO.getFileName());
                string = this.mergePdfFiles(pdfMap);
                if (!MapUtils.isNotEmpty(pdfMap)) break block14;
            }
            catch (Exception e) {
                throw new AppException("\u751f\u6210\u7684\u4e34\u65f6PDF\u6587\u4ef6\u62a5\u9519\uff0c\u5904\u7406\u7ec8\u6b62, \u5f02\u5e38\u539f\u56e0\uff1a" + e.toString());
            }
            finally {
                if (MapUtils.isNotEmpty(pdfMap)) {
                    for (Map.Entry entry : pdfMap.entrySet()) {
                        File pdfFile = new File((String)entry.getValue());
                        if (!pdfFile.exists()) continue;
                        pdfFile.delete();
                    }
                }
            }
            for (Map.Entry<String, String> entry : pdfMap.entrySet()) {
                File pdfFile = new File(entry.getValue());
                if (!pdfFile.exists()) continue;
                pdfFile.delete();
            }
        }
        return string;
    }

    @Override
    public String mergePdfFiles(Map<String, String> files) {
        if (MapUtils.isEmpty(files)) {
            LOGGER.error("\u5408\u5e76PDF\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u6307\u5b9a\u8981\u5408\u5e76\u7684PDF\u6587\u4ef6\uff01");
            throw new AppException("\u5408\u5e76PDF\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u6307\u5b9a\u8981\u5408\u5e76\u7684PDF\u6587\u4ef6\uff01");
        }
        String pdfFileName = this.generatePdfFileName();
        Document document = null;
        FileOutputStream fileOutputStream = null;
        try {
            document = new Document(new PdfReader(files.get("0")).getPageSize(1));
            fileOutputStream = new FileOutputStream(pdfFileName);
            PdfCopy copy = new PdfCopy(document, (OutputStream)fileOutputStream);
            document.open();
            for (int index = 0; index < files.size(); ++index) {
                PdfReader reader = new PdfReader(files.get(String.valueOf(index)));
                for (int i = 1; i <= reader.getNumberOfPages(); ++i) {
                    document.newPage();
                    copy.addPage(copy.getImportedPage(reader, i));
                }
                reader.close();
            }
            copy.close();
            LOGGER.debug("PDF\u5bfc\u51fa\u5408\u5e76\u6587\u4ef6\u5904\u7406\u5b8c\u6bd5\uff01");
            String string = pdfFileName;
            return string;
        }
        catch (Exception e) {
            throw new AppException("\u5408\u5e76PDF\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.toString());
        }
        finally {
            if (null != document) {
                document.close();
            }
            if (null != fileOutputStream) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("\u7cfb\u7edf\u5bfc\u51faPDF\u5173\u95ed\u8d44\u6e90\u62a5\u9519\uff1a{}", (Object)e.getMessage());
                }
            }
        }
    }

    @Override
    public String mergePdfFiles(Collection<String> files) {
        if (CollectionUtils.isEmpty(files)) {
            LOGGER.error("\u5408\u5e76PDF\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u6307\u5b9a\u8981\u5408\u5e76\u7684PDF\u6587\u4ef6\uff01");
            throw new AppException("\u5408\u5e76PDF\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u6307\u5b9a\u8981\u5408\u5e76\u7684PDF\u6587\u4ef6\uff01");
        }
        String pdfFileName = this.generatePdfFileName();
        Document document = null;
        FileOutputStream fileOutputStream = null;
        try {
            document = new Document(new PdfReader(files.iterator().next()).getPageSize(1));
            fileOutputStream = new FileOutputStream(pdfFileName);
            PdfCopy copy = new PdfCopy(document, (OutputStream)fileOutputStream);
            document.open();
            Iterator<String> iterator = files.iterator();
            while (iterator.hasNext()) {
                PdfReader reader = new PdfReader(iterator.next());
                for (int i = 1; i <= reader.getNumberOfPages(); ++i) {
                    document.newPage();
                    copy.addPage(copy.getImportedPage(reader, i));
                }
                reader.close();
            }
            copy.close();
            LOGGER.debug("PDF\u5bfc\u51fa\u5408\u5e76\u6587\u4ef6\u5904\u7406\u5b8c\u6bd5\uff01");
            String string = pdfFileName;
            return string;
        }
        catch (Exception e) {
            throw new AppException("\u5408\u5e76PDF\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.toString());
        }
        finally {
            if (null != document) {
                document.close();
            }
            if (null != fileOutputStream) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("\u7cfb\u7edf\u5bfc\u51faPDF\u5173\u95ed\u8d44\u6e90\u62a5\u9519\uff1a{}", (Object)e.getMessage());
                }
            }
        }
    }

    private String generatePdfFileName() {
        return this.printPath + "temp/" + UUIDGenerator.generate16() + ".pdf";
    }
}

