/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.core.support.pdf.service.impl;

import cn.gtmap.realestate.common.core.support.pdf.service.impl.OfficeDataServiceImpl;
import cn.gtmap.realestate.common.util.UUIDGenerator;
import com.deepoove.poi.NiceXWPFDocument;
import com.deepoove.poi.data.RowRenderData;
import com.deepoove.poi.data.style.TableStyle;
import com.deepoove.poi.policy.DynamicTableRenderPolicy;
import com.deepoove.poi.policy.MiniTableRenderPolicy;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.poi.xwpf.usermodel.ICell;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.TableRowAlign;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OfficeDocTablePolicy
extends DynamicTableRenderPolicy {
    private static final Logger LOGGER = LoggerFactory.getLogger(OfficeDocTablePolicy.class);
    private static final String PDF_WORD_SUBTABLE_NAME_REG = "\\{\\{TABLE_[A-Za-z0-9_]+\\}\\}";
    private static final String PDF_WORD_SUBTABLE_CELL_REG = "\\{\\{CELL_[A-Za-z0-9_]+\\}\\}";
    private static final String PDF_WORD_SUBTABLE_CHECKBOX_REG = "\\{\\{&[A-Za-z0-9_]+";
    private static final String PDF_WORD_SUBTABLE_CHECKBOX_ALL_REG = "\\{\\{&[A-Za-z0-9_]+[#[0-9]+#]?\\}\\}";
    private static final String PDF_WORD_SUBTABLE_IMAGE_REG = "\\{\\{>[A-Za-z0-9_]+";
    private static final String PDF_WORD_SUBTABLE_CELL_START_REG = "\\{\\{CELL_[A-Za-z0-9_]+";
    private static final String PDF_WORD_SUBTABLE_CELL_START2_REG = "{{CELL_";
    private static final String PDF_WORD_SUBTABLE_CHECKBOX_START_REG = "{{&";
    private static final String PDF_WORD_SUBTABLE_IMAGE_START_REG = "{{>";
    private static final String PDF_WORD_SUBTABLE_INNERTABLE_START_REG = "{{TABLE_ZB_";
    private static final String PDF_WORD_SUBTABLE_CELL_START3_REG = "{{";
    private static final String PDF_WORD_SUBTABLE_CELL_END_REG = "}}";
    private static final String PDF_WORD_SUBTABLE_INDEX_REG = "#[0-9]+#";
    private static final String PDF_WORD_SUBTABLE_INDEX_START_REG = "#";
    private static final String PDF_WORD_SUBTABLE_INDEX_END_REG = "#}}";
    private static final TableStyle TABLE_ROW_STYLE = new TableStyle();
    private Map<String, Object> officeData;

    public OfficeDocTablePolicy() {
    }

    public OfficeDocTablePolicy(Map<String, Object> data) {
        this.officeData = data;
    }

    public void render(XWPFTable table, Object data) {
        if (null == table || null == data) {
            LOGGER.error("PDF\u3001WORD\u5904\u7406\u6570\u636e\u8868\u683c\u4e2d\u6b62\uff0c\u539f\u56e0\uff1a\u6ca1\u6709\u5b9a\u4e49\u6570\u636e\u8868\u683c\u6216\u8005\u65e0\u5bf9\u5e94\u6570\u636e\uff01");
            return;
        }
        List tableData = (List)data;
        if (CollectionUtils.isEmpty((Collection)tableData)) {
            LOGGER.error("PDF\u3001WORD\u5904\u7406\u6570\u636e\u8868\u683c\u4e2d\u6b62\uff0c\u539f\u56e0\uff1a\u65e0\u5bf9\u5e94\u6570\u636e\uff01");
            return;
        }
        String tableName = this.getTableName(table);
        try {
            if (this.isExpandTable(tableName)) {
                this.resolveMergeTable(table, tableData);
            } else {
                this.resolveGeneralTable(table, tableData);
            }
        }
        catch (Exception exception) {
            LOGGER.error("\u5bfc\u51faPDF\u3001WORD\u5904\u7406\u5b50\u8868\u51fa\u73b0\u9519\u8bef\uff1a{}", (Object)exception.getMessage());
            throw exception;
        }
    }

    private boolean isExpandTable(String tableName) {
        return StringUtils.startsWith((CharSequence)tableName, (CharSequence)"TABLE_ZT_") || StringUtils.startsWith((CharSequence)tableName, (CharSequence)"TABLE_zt_");
    }

    private void resolveMergeTable(XWPFTable table, List<Map<String, Object>> data) {
        List rows = table.getRows();
        if (CollectionUtils.isEmpty((Collection)rows)) {
            LOGGER.error("PDF\u3001WORD\u5904\u7406\u6570\u636e\u8868\u683c\u4e2d\u6b62\uff0c\u539f\u56e0\uff1a\u8868\u683c\u65e0\u6570\u636e\u884c\u5185\u5bb9\uff01");
            return;
        }
        int size = rows.size();
        for (int index = 1; index < data.size(); ++index) {
            for (int i = 0; i < size; ++i) {
                XWPFTableRow newRow = table.insertNewTableRow(table.getRows().size());
                this.copyTableRow(newRow, (XWPFTableRow)rows.get(i), index);
            }
        }
        this.setTableData(table.getRows(), data);
    }

    public void copyTableRow(XWPFTableRow target, XWPFTableRow source, int index) {
        if (source.getCtRow() != null) {
            target.getCtRow().setTrPr(source.getCtRow().getTrPr());
        }
        for (int i = 0; i < source.getTableCells().size(); ++i) {
            XWPFTableCell cell1 = target.getCell(i);
            XWPFTableCell cell2 = source.getCell(i);
            if (cell1 == null) {
                cell1 = target.addNewTableCell();
            }
            this.copyTableCell(cell1, cell2, index);
        }
    }

    public void copyTableCell(XWPFTableCell target, XWPFTableCell source, int index) {
        if (source.getCTTc() != null) {
            target.getCTTc().setTcPr(source.getCTTc().getTcPr());
        }
        for (int pos = 0; pos < target.getParagraphs().size(); ++pos) {
            target.removeParagraph(pos);
        }
        for (XWPFParagraph sp : source.getParagraphs()) {
            XWPFParagraph targetP = target.addParagraph();
            this.copyParagraph(targetP, sp, index);
        }
    }

    public void copyParagraph(XWPFParagraph target, XWPFParagraph source, int index) {
        target.getCTP().setPPr(source.getCTP().getPPr());
        for (int pos = target.getRuns().size() - 1; pos >= 0; --pos) {
            target.removeRun(pos);
        }
        for (XWPFRun s : source.getRuns()) {
            XWPFRun targetrun = target.createRun();
            this.copyRun(targetrun, s, index);
        }
    }

    public void copyRun(XWPFRun target, XWPFRun source, int index) {
        target.getCTR().setRPr(source.getCTR().getRPr());
        String text = source.text();
        if (StringUtils.startsWith((CharSequence)text, (CharSequence)PDF_WORD_SUBTABLE_CELL_START3_REG)) {
            String endIndex = PDF_WORD_SUBTABLE_INDEX_START_REG + index + PDF_WORD_SUBTABLE_INDEX_END_REG;
            text = text.replace(PDF_WORD_SUBTABLE_CELL_END_REG, endIndex);
        }
        target.setText(text);
    }

    private void setTableData(List<XWPFTableRow> rows, List<Map<String, Object>> data) {
        int subTableIndex = 1;
        HashMap<String, Integer> checkBoxMap = new HashMap<String, Integer>(10);
        for (XWPFTableRow row : rows) {
            List cells = row.getTableICells();
            for (ICell cell : cells) {
                String text = ((XWPFTableCell)cell).getText();
                if (StringUtils.startsWith((CharSequence)text, (CharSequence)PDF_WORD_SUBTABLE_CHECKBOX_START_REG)) {
                    if (checkBoxMap.containsKey(text)) {
                        int checkBoxIndex = (Integer)checkBoxMap.get(text);
                        checkBoxMap.put(text, ++checkBoxIndex);
                    } else {
                        checkBoxMap.put(text, 0);
                    }
                    this.resolveCheckBox(data, (XWPFTableCell)cell, text, (Integer)checkBoxMap.get(text));
                    continue;
                }
                if (text.startsWith(PDF_WORD_SUBTABLE_IMAGE_START_REG)) {
                    this.resolveImage(data, (XWPFTableCell)cell, text);
                    continue;
                }
                if (text.endsWith(PDF_WORD_SUBTABLE_INDEX_END_REG)) {
                    this.resolveExpandTable(data, (XWPFTableCell)cell, text);
                    continue;
                }
                if (text.startsWith(PDF_WORD_SUBTABLE_INNERTABLE_START_REG)) {
                    subTableIndex = this.resolveInnerTable(subTableIndex, (XWPFTableCell)cell, text);
                    continue;
                }
                if (!text.startsWith(PDF_WORD_SUBTABLE_CELL_START3_REG)) continue;
                this.resolveFirstTable(data, (XWPFTableCell)cell, text);
            }
        }
    }

    private void resolveImage(List<Map<String, Object>> data, XWPFTableCell cell, String text) {
        int indexNum = 0;
        String index = this.splitStr(text, PDF_WORD_SUBTABLE_INDEX_REG);
        if (StringUtils.isNotBlank((CharSequence)index)) {
            index = index.replace(PDF_WORD_SUBTABLE_INDEX_START_REG, "");
            indexNum = Integer.parseInt(index);
        }
        String cellName = this.splitStr(text, PDF_WORD_SUBTABLE_IMAGE_REG);
        List paragraphs = cell.getParagraphs();
        Iterator it = paragraphs.iterator();
        int pos = paragraphs.size() - 1;
        while (it.hasNext()) {
            cell.removeParagraph(pos--);
        }
        XWPFParagraph paragraph = cell.addParagraph();
        paragraph.setAlignment(ParagraphAlignment.CENTER);
        XWPFRun run = paragraph.createRun();
        try {
            String pictureUrl = (String)data.get(indexNum).get(cellName);
            if (StringUtils.isBlank((CharSequence)pictureUrl)) {
                LOGGER.error("\u5bfc\u51faPDF\u3001WORD\u5904\u7406\u5b50\u8868\u56fe\u7247\u5931\u8d25\uff0c\u5b57\u6bb5\u540d\u79f0\uff1a{}\uff0c\u56e0\u4e3a\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u6570\u636e", (Object)cellName);
                return;
            }
            byte[] imageByteData = this.readRemoteFileToByteArray(pictureUrl);
            if (null != imageByteData) {
                run.addPicture((InputStream)new ByteArrayInputStream(imageByteData), 6, cellName, 20, 20);
            }
        }
        catch (Exception exception) {
            LOGGER.error("\u5bfc\u51faPDF\u3001WORD\u5904\u7406\u5b50\u8868\u56fe\u7247\u5931\u8d25\uff0c\u5b57\u6bb5\u540d\u79f0\uff1a{}\uff0c{}", (Object)cellName, (Object)exception.getMessage());
        }
    }

    private void resolveFirstTable(List<Map<String, Object>> data, XWPFTableCell cell, String text) {
        String cellName = this.splitStr(text, PDF_WORD_SUBTABLE_CELL_REG);
        String val = (String)data.get(0).get(cellName);
        cell.setText(val);
    }

    private void resolveExpandTable(List<Map<String, Object>> data, XWPFTableCell cell, String text) {
        XWPFParagraph paragraph;
        String index = this.splitStr(text, PDF_WORD_SUBTABLE_INDEX_REG);
        index = index.replace(PDF_WORD_SUBTABLE_INDEX_START_REG, "");
        String cellName = this.splitStr(text, PDF_WORD_SUBTABLE_CELL_START_REG);
        String val = (String)data.get(Integer.valueOf(index)).get(cellName);
        if (CollectionUtils.isNotEmpty((Collection)cell.getParagraphs()) && CollectionUtils.isNotEmpty((Collection)(paragraph = (XWPFParagraph)cell.getParagraphs().get(0)).getRuns())) {
            paragraph.removeRun(0);
            XWPFRun run = paragraph.createRun();
            run.setText(val);
        }
    }

    private int resolveInnerTable(int subTableIndex, XWPFTableCell cell, String text) {
        String[] arr = text.replace(PDF_WORD_SUBTABLE_CELL_START3_REG, "").replace(PDF_WORD_SUBTABLE_CELL_END_REG, "").split("_&&_");
        if (null == arr || arr.length < 2) {
            return subTableIndex;
        }
        String subTableId = arr[0] + "_" + subTableIndex;
        List subTableData = (List)this.officeData.get(subTableId);
        if (CollectionUtils.isEmpty((Collection)subTableData)) {
            this.setCellText(cell, "");
            return ++subTableIndex;
        }
        String items = arr[1];
        String[] itemsArr = items.split(":");
        if (null == itemsArr) {
            return subTableIndex;
        }
        int rowNum = subTableData.size();
        int colNum = itemsArr.length;
        List paragraphs = cell.getParagraphs();
        Iterator it = paragraphs.iterator();
        int pos = paragraphs.size() - 1;
        while (it.hasNext()) {
            cell.removeParagraph(pos--);
        }
        XWPFParagraph paragraph = cell.addParagraph();
        paragraph.setAlignment(ParagraphAlignment.CENTER);
        XWPFRun run = paragraph.createRun();
        XWPFTable subTable = ((NiceXWPFDocument)cell.getXWPFDocument()).insertNewTable(run, rowNum, colNum);
        subTable.setTableAlignment(TableRowAlign.CENTER);
        subTable.setCellMargins(0, 0, 0, 0);
        for (int r = 0; r < rowNum; ++r) {
            for (int c = 0; c < colNum; ++c) {
                XWPFParagraph p1 = subTable.getRow(r).getCell(c).addParagraph();
                XWPFRun r1 = p1.createRun();
                r1.setText(String.valueOf(((Map)subTableData.get(r)).get(itemsArr[c].toLowerCase())));
            }
        }
        List newParagraphs = cell.getParagraphs();
        if (CollectionUtils.isNotEmpty((Collection)newParagraphs)) {
            cell.removeParagraph(newParagraphs.size() - 1);
        }
        return ++subTableIndex;
    }

    private void setCellText(XWPFTableCell cell, String text) {
        List paragraphs = cell.getParagraphs();
        if (CollectionUtils.isNotEmpty((Collection)paragraphs)) {
            Iterator it = paragraphs.iterator();
            int pos = paragraphs.size() - 1;
            while (it.hasNext()) {
                cell.removeParagraph(pos--);
            }
        }
        XWPFParagraph paragraph = cell.addParagraph();
        paragraph.setAlignment(ParagraphAlignment.CENTER);
        XWPFRun run = paragraph.createRun();
        run.setText(text);
    }

    private void resolveCheckBox(List<Map<String, Object>> data, XWPFTableCell cell, String text, int checkBoxIndex) {
        int indexNum = 0;
        if (StringUtils.contains((CharSequence)text, (CharSequence)PDF_WORD_SUBTABLE_INDEX_END_REG)) {
            String index = this.splitStr(text, PDF_WORD_SUBTABLE_INDEX_REG);
            if (StringUtils.isNotBlank((CharSequence)index)) {
                index = index.replace(PDF_WORD_SUBTABLE_INDEX_START_REG, "");
                indexNum = Integer.parseInt(index);
            }
        } else {
            indexNum = checkBoxIndex;
        }
        String cellName = this.splitStr(text, PDF_WORD_SUBTABLE_CHECKBOX_REG);
        String info = text.replaceAll(PDF_WORD_SUBTABLE_CHECKBOX_ALL_REG, "");
        List paragraphs = cell.getParagraphs();
        Iterator it = paragraphs.iterator();
        int pos = paragraphs.size() - 1;
        while (it.hasNext()) {
            cell.removeParagraph(pos--);
        }
        XWPFParagraph paragraph = cell.addParagraph();
        paragraph.setAlignment(ParagraphAlignment.LEFT);
        XWPFRun run = paragraph.createRun();
        try {
            String pictureName = (String)data.get(indexNum).get(cellName);
            if (StringUtils.isBlank((CharSequence)pictureName)) {
                LOGGER.error("\u5bfc\u51faPDF\u3001WORD\u5904\u7406\u5b50\u8868\u590d\u9009\u6846\u5931\u8d25\uff0c\u5b57\u6bb5\u540d\u79f0\uff1a{}\uff0c\u56e0\u4e3a\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u6570\u636e", (Object)cellName);
                return;
            }
            byte[] checkBoxData = StringUtils.equals((CharSequence)pictureName, (CharSequence)"CheckboxY.png") ? OfficeDataServiceImpl.checkBoxY : OfficeDataServiceImpl.checkBoxN;
            run.addPicture((InputStream)new ByteArrayInputStream(checkBoxData), 6, cellName, 12, 12);
            XWPFRun infoRun = paragraph.createRun();
            infoRun.setText(info);
        }
        catch (Exception exception) {
            LOGGER.error("\u5bfc\u51faPDF\u3001WORD\u5904\u7406\u5b50\u8868\u590d\u9009\u6846\u5931\u8d25\uff0c\u5b57\u6bb5\u540d\u79f0\uff1a{}\uff0c{}", (Object)cellName, (Object)exception.getMessage());
        }
    }

    private void resolveGeneralTable(XWPFTable table, List<Map<String, Object>> data) {
        List<String> cellNameList = this.getTableCellName(table);
        if (CollectionUtils.isEmpty(cellNameList)) {
            return;
        }
        List<Map<String, Object>> labors = data;
        if (CollectionUtils.isNotEmpty(labors)) {
            table.removeRow(1);
            for (int i = labors.size() - 1; i >= 0; --i) {
                XWPFTableRow insertNewTableRow = table.insertNewTableRow(1);
                int cellSize = CollectionUtils.isEmpty(cellNameList) ? labors.get(i).size() : cellNameList.size();
                for (int j = 0; j < cellSize; ++j) {
                    insertNewTableRow.createCell();
                }
                String[] cellDatas = new String[cellSize];
                Map<String, Object> cellData = labors.get(i);
                if (CollectionUtils.isEmpty(cellNameList)) {
                    int index = 0;
                    for (Map.Entry<String, Object> entry : cellData.entrySet()) {
                        cellDatas[index++] = String.valueOf(entry.getValue());
                    }
                } else {
                    for (int k = 0; k < cellSize; ++k) {
                        String dataStr;
                        Object itemData = cellData.get(cellNameList.get(k));
                        cellDatas[k] = dataStr = null == itemData ? "" : String.valueOf(itemData);
                    }
                }
                RowRenderData row = RowRenderData.build((String[])cellDatas);
                row.setRowStyle(TABLE_ROW_STYLE);
                MiniTableRenderPolicy.Helper.renderRow((XWPFTable)table, (int)1, (RowRenderData)row);
            }
        }
    }

    private String getTableName(XWPFTable table) {
        Pattern pattern = Pattern.compile(PDF_WORD_SUBTABLE_NAME_REG);
        Matcher matcher = pattern.matcher(table.getText());
        String tableName = "";
        if (matcher.find()) {
            tableName = matcher.group();
        }
        return tableName.replace(PDF_WORD_SUBTABLE_CELL_START3_REG, "").replace(PDF_WORD_SUBTABLE_CELL_END_REG, "");
    }

    private List<String> getTableCellName(XWPFTable table) {
        String text = table.getText();
        if (StringUtils.isBlank((CharSequence)text)) {
            return null;
        }
        Pattern pattern = Pattern.compile(PDF_WORD_SUBTABLE_CELL_REG);
        Matcher matcher = pattern.matcher(text);
        ArrayList<String> cellNameList = new ArrayList<String>(10);
        while (matcher.find()) {
            cellNameList.add(matcher.group().replace(PDF_WORD_SUBTABLE_CELL_START2_REG, "").replace(PDF_WORD_SUBTABLE_CELL_END_REG, ""));
        }
        return cellNameList;
    }

    private String splitStr(String str, String reg) {
        Pattern pattern = Pattern.compile(reg);
        Matcher matcher = pattern.matcher(str);
        if (matcher.find()) {
            return matcher.group().replace(PDF_WORD_SUBTABLE_CELL_START2_REG, "").replace(PDF_WORD_SUBTABLE_CHECKBOX_START_REG, "").replace(PDF_WORD_SUBTABLE_IMAGE_START_REG, "").replace(PDF_WORD_SUBTABLE_CELL_END_REG, "");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readRemoteFileToByteArray(String filePath) {
        File file = new File(UUIDGenerator.generate16() + ".png");
        try {
            FileUtils.copyURLToFile((URL)new URIBuilder(filePath).build().toURL(), (File)file);
            byte[] byArray = FileUtils.readFileToByteArray((File)file);
            return byArray;
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u51faPDF\u3001WORD\u83b7\u53d6\u8fdc\u7a0b\u56fe\u7247\u6587\u4ef6\u5931\u8d25\uff0c\u6587\u4ef6\uff1a{}", (Object)filePath);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (file.exists()) {
                file.delete();
            }
        }
    }

    static {
        TABLE_ROW_STYLE.setAlign(STJc.CENTER);
    }
}

