/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.core.support.pdf.service.impl;

import cn.gtmap.realestate.common.core.support.pdf.service.OfficeDataService;
import com.deepoove.poi.data.PictureRenderData;
import com.deepoove.poi.util.BytePictureUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OfficeDataServiceImpl
implements OfficeDataService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OfficeDataServiceImpl.class);
    @Value(value="${print.path:/usr/local/bdc3/print/}")
    private String printPath;
    public static byte[] checkBoxY;
    public static byte[] checkBoxN;

    @PostConstruct
    public void init() {
        try {
            checkBoxY = FileUtils.readFileToByteArray((File)new File(this.printPath + "CheckboxY.png"));
            checkBoxN = FileUtils.readFileToByteArray((File)new File(this.printPath + "CheckboxN.png"));
        }
        catch (IOException e) {
            LOGGER.error("\u5bfc\u51faPDF\u3001WORD\u521d\u59cb\u5316\u83b7\u53d6\u590d\u9009\u6846\u56fe\u7247\u6570\u636e\u5931\u8d25\uff0c\u56e0\u4e3a\u672a\u627e\u5230\u5bf9\u5e94\u6587\u4ef6!");
        }
    }

    @Override
    public List<Map<String, Object>> getValDataList(String xmlData) throws DocumentException {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(10);
        Document document = DocumentHelper.parseText((String)xmlData.replaceAll("&", "&amp;"));
        Element root = document.getRootElement();
        if (StringUtils.contains((CharSequence)xmlData, (CharSequence)"page")) {
            List pageList = root.elements("page");
            for (Element page : pageList) {
                result.add(this.getValDataMap(page));
            }
        } else {
            result.add(this.getValDataMap(root));
        }
        return result;
    }

    private Map getValDataMap(Element element) {
        if (null == element) {
            return null;
        }
        List datasList = element.elements("datas");
        if (CollectionUtils.isEmpty((Collection)datasList) || null == datasList.get(0)) {
            return null;
        }
        List dataList = ((Element)datasList.get(0)).elements("data");
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(dataList.size());
        for (Element data : dataList) {
            String name = data.attribute("name").getValue();
            String type = data.attribute("type").getValue();
            if (this.isImageType(type)) {
                this.addImageType(map, data, name, false);
                continue;
            }
            if (!this.isStrType(type)) continue;
            if (this.isCheckBox(name)) {
                this.addCheckBoxType(map, data, false);
                continue;
            }
            map.put(name, data.getText());
        }
        return this.getSubTables(element, map);
    }

    private boolean isImageType(String type) {
        return "image".equals(type) || "Image".equals(type) || "IMAGE".equals(type);
    }

    private boolean isStrType(String type) {
        return "String".equals(type) || "string".equals(type) || "STRING".equals(type);
    }

    private void addImageType(Map<String, Object> map, Element data, String name, boolean isSetPictureUrl) {
        try {
            String text = data.getText();
            if (StringUtils.isBlank((CharSequence)text)) {
                LOGGER.error("\u5bfc\u51faPDF\u3001WORD\u5904\u7406\u56fe\u7247\u4e2d\u6b62\uff0c\u9519\u8bef\u539f\u56e0\uff1a\u672a\u5b9a\u4e49\u56fe\u7247\u8def\u5f84\uff0c\u5bf9\u5e94\u5b57\u6bb5\u540d\u79f0\uff1a{}", (Object)name);
                return;
            }
            if (isSetPictureUrl) {
                map.put(name, text);
            } else {
                map.put(name, new PictureRenderData(90, 90, ".png", BytePictureUtils.getUrlBufferedImage((String)text)));
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u51faPDF\u3001WORD\u5904\u7406\u56fe\u7247\u9519\u8bef\uff0c\u5bf9\u5e94\u5b57\u6bb5\uff1a{}\uff0c\u9519\u8bef\u539f\u56e0\uff1a{}", (Object)name, (Object)e.getMessage());
        }
    }

    private void addCheckBoxType(Map<String, Object> map, Element data, boolean isSetPictureName) {
        String name = data.attribute("name").getValue();
        String itemName = name.replace("CHECKBOX#", "");
        itemName = itemName.replace("checkbox#", "");
        String text = data.getText();
        if (StringUtils.isNotBlank((CharSequence)text)) {
            String[] valArr;
            String[] textArr = text.split("_");
            for (String val : valArr = textArr[0].split(",")) {
                if (isSetPictureName) {
                    map.put(itemName + "_" + val, "CheckboxY.png");
                    continue;
                }
                map.put(itemName + "_" + val, new PictureRenderData(12, 12, this.printPath + "CheckboxY.png"));
            }
            if (textArr.length > 1) {
                String[] otherValArr;
                for (String val : otherValArr = textArr[1].split(",")) {
                    if (isSetPictureName) {
                        map.put(itemName + "_" + val, "CheckboxN.png");
                        continue;
                    }
                    map.put(itemName + "_" + val, new PictureRenderData(12, 12, this.printPath + "CheckboxN.png"));
                }
            }
        }
    }

    private Map getSubTables(Element element, Map<String, Object> map) {
        List detailElements = element.elements("detail");
        if (CollectionUtils.isEmpty((Collection)detailElements)) {
            return map;
        }
        for (Element detailElement : detailElements) {
            String tableId = detailElement.attribute("ID").getValue();
            List detailRowElements = detailElement.elements("row");
            if (CollectionUtils.isEmpty((Collection)detailRowElements)) continue;
            int maxZbxh = 0;
            ArrayList<HashMap<String, Object>> rowDataList = new ArrayList<HashMap<String, Object>>(detailRowElements.size());
            for (Element element2 : detailRowElements) {
                List rowDatas = element2.elements("data");
                if (!CollectionUtils.isNotEmpty((Collection)rowDatas)) continue;
                HashMap<String, Object> dataMap = new HashMap<String, Object>(rowDatas.size());
                for (Element rowData : rowDatas) {
                    String name = rowData.attribute("name").getValue();
                    String type = rowData.attribute("type").getValue();
                    String value = rowData.getText();
                    if (this.isImageType(type)) {
                        this.addImageType(dataMap, rowData, name, true);
                    } else if (this.isStrType(type)) {
                        if (this.isCheckBox(name)) {
                            this.addCheckBoxType(dataMap, rowData, true);
                        } else {
                            dataMap.put(name, value);
                        }
                    }
                    if (!"zbxh".equals(name) || Integer.valueOf(value) <= maxZbxh) continue;
                    maxZbxh = Integer.valueOf(value);
                }
                rowDataList.add(dataMap);
            }
            if (tableId.startsWith("ZB_") || tableId.startsWith("zb_")) {
                for (Map map2 : rowDataList) {
                    String zbxh = String.valueOf(map2.get("zbxh"));
                    String subTableId = "TABLE_" + tableId + "_" + zbxh;
                    if (map.keySet().contains(subTableId)) {
                        ((List)map.get(subTableId)).add(map2);
                        continue;
                    }
                    ArrayList<Map> subTableDataList = new ArrayList<Map>(5);
                    subTableDataList.add(map2);
                    map.put(subTableId, subTableDataList);
                }
                continue;
            }
            map.put("TABLE_" + tableId, rowDataList);
        }
        return map;
    }

    private boolean isCheckBox(String name) {
        return name.startsWith("CHECKBOX#") || name.startsWith("checkbox#");
    }
}

