/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.core.support.pdf;

import cn.gtmap.realestate.common.core.dto.OfficeExportDTO;
import cn.gtmap.realestate.common.core.ex.AppException;
import cn.gtmap.realestate.common.core.support.pdf.service.OfficeDocService;
import cn.gtmap.realestate.common.core.support.pdf.service.OfficePdfService;
import com.deepoove.poi.NiceXWPFDocument;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/office"})
public class PdfController {
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfController.class);
    @Value(value="${print.path:/usr/local/bdc3/print/}")
    private String path;
    @Autowired
    private OfficeDocService officeDocService;
    @Autowired
    private OfficePdfService officePdfService;

    @GetMapping(value={"/word/export"})
    public void exportWord(HttpServletResponse response, @ModelAttribute OfficeExportDTO officeExportDTO) {
        if (null == officeExportDTO) {
            throw new AppException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u4f20\u5165\u6253\u5370\u6709\u6548\u53c2\u6570!");
        }
        if (StringUtils.isBlank((CharSequence)officeExportDTO.getModelName())) {
            throw new AppException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u6307\u5b9a\u6253\u5370\u6a21\u677f!");
        }
        if (StringUtils.isBlank((CharSequence)officeExportDTO.getXmlData())) {
            throw new AppException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u6307\u5b9a\u6253\u5370\u6570\u636e\u6e90!");
        }
        this.resolveModelFile(officeExportDTO);
        try (ServletOutputStream outputStream = response.getOutputStream();
             NiceXWPFDocument xwpfDocument = this.officeDocService.getXwpfDocument(officeExportDTO);){
            String fileName = StringUtils.isBlank((CharSequence)officeExportDTO.getFileName()) ? "\u6279\u91cfWORD\u6587\u4ef6" : officeExportDTO.getFileName();
            String file = URLEncoder.encode(fileName + ".docx", "utf-8");
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment;filename=" + file);
            if (null != xwpfDocument) {
                xwpfDocument.write((OutputStream)outputStream);
                outputStream.flush();
            }
        }
        catch (Exception e) {
            LOGGER.error("\u7cfb\u7edf\u5bfc\u51faWORD\u62a5\u9519\uff1a{}", (Object)e.getMessage());
        }
    }

    @GetMapping(value={"/pdf/export"})
    public void exportPdf(HttpServletResponse response, @ModelAttribute OfficeExportDTO officeExportDTO) {
        if (null == officeExportDTO) {
            throw new AppException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u4f20\u5165\u6253\u5370\u6709\u6548\u53c2\u6570!");
        }
        if (StringUtils.isBlank((CharSequence)officeExportDTO.getModelName())) {
            throw new AppException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u6307\u5b9a\u6253\u5370\u6a21\u677f!");
        }
        if (StringUtils.isBlank((CharSequence)officeExportDTO.getXmlData())) {
            throw new AppException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u6307\u5b9a\u6253\u5370\u6570\u636e\u6e90!");
        }
        this.resolveModelFile(officeExportDTO);
        FileInputStream pdfInputStream = null;
        ServletOutputStream outputStream = null;
        String pdfFileName = null;
        try {
            outputStream = response.getOutputStream();
            pdfFileName = this.officePdfService.generatePdfFile(officeExportDTO);
            if (StringUtils.isBlank((CharSequence)pdfFileName)) {
                LOGGER.error("\u7cfb\u7edf\u5bfc\u51faPDF\u5931\u8d25\uff0c\u56e0\u4e3a\u672a\u6210\u529f\u751f\u6210PDF\u6587\u4ef6\uff0c\u76ee\u6807\u6587\u4ef6\u540d\uff1a{}", (Object)officeExportDTO.getFileName());
                throw new AppException("\u7cfb\u7edf\u5bfc\u51faPDF\u5931\u8d25\uff0c\u56e0\u4e3a\u672a\u6210\u529f\u751f\u6210PDF\u6587\u4ef6");
            }
            File pdfFile = new File(pdfFileName);
            if (!pdfFile.exists() || pdfFile.length() == 0L || !pdfFile.canRead()) {
                LOGGER.error("\u7cfb\u7edf\u5bfc\u51faPDF\u5931\u8d25\uff0c\u76ee\u6807PDF\u6587\u4ef6\u4e0d\u53ef\u64cd\u4f5c\u6216\u65e0\u5185\u5bb9\uff1a{}", (Object)pdfFileName);
                throw new AppException("\u7cfb\u7edf\u5bfc\u51faPDF\u5931\u8d25\uff0c\u76ee\u6807PDF\u6587\u4ef6\u4e0d\u53ef\u64cd\u4f5c\u6216\u65e0\u5185\u5bb9");
            }
            String fileName = StringUtils.isBlank((CharSequence)officeExportDTO.getFileName()) ? "\u6279\u91cfPDF\u6587\u4ef6" : officeExportDTO.getFileName();
            String file = URLEncoder.encode(fileName + ".pdf", "utf-8");
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment;filename=" + file);
            pdfInputStream = new FileInputStream(pdfFile);
            byte[] bytes = new byte[1024];
            while (pdfInputStream.read(bytes) != -1) {
                outputStream.write(bytes);
            }
            outputStream.flush();
        }
        catch (Exception e) {
            LOGGER.error("\u7cfb\u7edf\u5bfc\u51faPDF\u62a5\u9519\uff1a{}", (Object)e.toString());
            throw new AppException("\u7cfb\u7edf\u5bfc\u51faPDF\u62a5\u9519\uff0c\u5904\u7406\u7ec8\u6b62");
        }
        finally {
            File file;
            if (null != pdfInputStream) {
                try {
                    pdfInputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("\u7cfb\u7edf\u5bfc\u51faPDF\u5173\u95ed\u8d44\u6e90\u62a5\u9519\uff1a{}", (Object)e.getMessage());
                }
            }
            if (null != outputStream) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("\u7cfb\u7edf\u5bfc\u51faPDF\u5173\u95ed\u8d44\u6e90\u62a5\u9519\uff1a{}", (Object)e.getMessage());
                }
            }
            if (null != pdfFileName && (file = new File(pdfFileName)).exists()) {
                file.delete();
            }
        }
    }

    @PostMapping(value={"/pdf/file"})
    public String generatePdfFile(@RequestBody OfficeExportDTO officeExportDTO) {
        if (null == officeExportDTO) {
            throw new AppException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u4f20\u5165\u6253\u5370\u6709\u6548\u53c2\u6570!");
        }
        if (StringUtils.isBlank((CharSequence)officeExportDTO.getModelName())) {
            throw new AppException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u6307\u5b9a\u6253\u5370\u6a21\u677f!");
        }
        if (StringUtils.isBlank((CharSequence)officeExportDTO.getXmlData())) {
            throw new AppException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u6307\u5b9a\u6253\u5370\u6570\u636e\u6e90!");
        }
        this.resolveModelFile(officeExportDTO);
        return this.officePdfService.generatePdfFile(officeExportDTO);
    }

    private void resolveModelFile(OfficeExportDTO officeExportDTO) {
        String filePath = officeExportDTO.getModelName();
        if (!PdfController.isHttpUrl(filePath)) {
            File diskFile = new File(filePath);
            if (!diskFile.exists()) {
                LOGGER.error("\u7cfb\u7edf\u5bfc\u51faPDF\u5931\u8d25\uff0c\u56e0\u4e3a\u672a\u627e\u5230\u672c\u5730\u6a21\u677f\u6587\u4ef6\uff1a{}", (Object)officeExportDTO.getModelName());
                throw new AppException("\u7cfb\u7edf\u5bfc\u51faPDF\u62a5\u9519\uff0c\u5904\u7406\u7ec8\u6b62");
            }
        } else {
            String[] urlArr = filePath.split("/");
            if (null == urlArr) {
                LOGGER.error("\u7cfb\u7edf\u5bfc\u51faPDF\u5931\u8d25\uff0c\u56e0\u4e3a\u672a\u627e\u5230\u672c\u5730\u6a21\u677f\u6587\u4ef6\uff1a{}", (Object)officeExportDTO.getModelName());
                throw new AppException("\u7cfb\u7edf\u5bfc\u51faPDF\u62a5\u9519\uff0c\u5904\u7406\u7ec8\u6b62");
            }
            String urlFileName = urlArr[urlArr.length - 1] + ".docx";
            File diskFile = new File(this.path + urlFileName);
            if (!diskFile.exists()) {
                try {
                    FileUtils.copyURLToFile((URL)new URIBuilder(filePath).build().toURL(), (File)diskFile, (int)5000, (int)30000);
                }
                catch (Exception e) {
                    LOGGER.error("\u7cfb\u7edf\u5bfc\u51faPDF\u5931\u8d25\uff0c\u56e0\u4e3a\u6a21\u677f\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff1a{}, {}", (Object)officeExportDTO.getModelName(), (Object)e.getMessage());
                    throw new AppException("\u7cfb\u7edf\u5bfc\u51faPDF\u62a5\u9519\uff0c\u5904\u7406\u7ec8\u6b62");
                }
            }
            officeExportDTO.setModelName(diskFile.getAbsolutePath());
        }
    }

    private static boolean isHttpUrl(String urls) {
        String regex = "[a-zA-z]+://[^\\s]*";
        Pattern pat = Pattern.compile(regex.trim());
        Matcher mat = pat.matcher(urls.trim());
        return mat.matches();
    }
}

