/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.core.support.mybatis.utils;

import cn.gtmap.realestate.common.core.support.mybatis.mapper.EntityMapper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Id;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnnotationsUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityMapper.class);

    private AnnotationsUtils() {
    }

    public static Method getAnnotationsName(Object vo) {
        Method method = null;
        String name = null;
        Class<?> entity = vo.getClass();
        if (entity != null) {
            Field[] fields;
            for (Field f : fields = entity.getDeclaredFields()) {
                if (!f.isAnnotationPresent(Id.class)) continue;
                name = f.getName();
                break;
            }
            if (StringUtils.isEmpty(name) && entity.getSuperclass() != null) {
                Field[] fieldsSuper;
                for (Field f : fieldsSuper = entity.getSuperclass().getDeclaredFields()) {
                    if (!f.isAnnotationPresent(Id.class)) continue;
                    name = f.getName();
                    break;
                }
            }
        }
        try {
            if (name != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name})) {
                name = "get" + StringUtils.substring(name, (int)0, (int)1).toUpperCase() + StringUtils.substring((String)name, (int)1, (int)name.length());
                method = entity.getMethod(name, new Class[0]);
            }
        }
        catch (NoSuchMethodException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return method;
    }

    public static Method setAnnotationsName(Object vo) {
        Method method = null;
        String name = null;
        Class<?> entity = vo.getClass();
        if (entity != null) {
            Field[] fields;
            for (Field f : fields = entity.getDeclaredFields()) {
                if (!f.isAnnotationPresent(Id.class)) continue;
                name = f.getName();
                break;
            }
            if (StringUtils.isEmpty(name) && entity.getSuperclass() != null) {
                Field[] fieldsSuper;
                for (Field f : fieldsSuper = entity.getSuperclass().getDeclaredFields()) {
                    if (!f.isAnnotationPresent(Id.class)) continue;
                    name = f.getName();
                    break;
                }
            }
        }
        try {
            if (name != null && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name})) {
                name = "set" + StringUtils.substring(name, (int)0, (int)1).toUpperCase() + StringUtils.substring((String)name, (int)1, (int)name.length());
                method = entity.getMethod(name, new Class[0]);
            }
        }
        catch (NoSuchMethodException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return method;
    }

    public static String getAnnotationFieldName(Object obj, Class annotationClass) {
        Field[] fields;
        String name = "";
        for (Field f : fields = obj.getClass().getDeclaredFields()) {
            if (!f.isAnnotationPresent(annotationClass)) continue;
            name = f.getName();
            break;
        }
        return name;
    }

    public static List<Field> getAnnotationField(Object obj, Class annotationClass) {
        ArrayList<Field> annotationfieldsfieldList = new ArrayList<Field>();
        ArrayList<Object> fieldList = new ArrayList<Object>();
        Field[] fields = obj.getClass().getDeclaredFields();
        if (fields != null && fields.length > 0) {
            for (Field field : fields) {
                fieldList.add(field);
            }
        }
        if (obj.getClass().getSuperclass() != null && (fields = obj.getClass().getSuperclass().getDeclaredFields()) != null && fields.length > 0) {
            for (Field field : fields) {
                fieldList.add(field);
            }
        }
        if (!fieldList.isEmpty()) {
            for (Field field : fieldList) {
                if (!field.isAnnotationPresent(annotationClass)) continue;
                annotationfieldsfieldList.add(field);
            }
        }
        return annotationfieldsfieldList;
    }
}

