/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.core.support.mybatis.page.repository;

import cn.gtmap.realestate.common.core.support.mybatis.page.PaginationInterceptor;
import cn.gtmap.realestate.common.core.support.mybatis.page.repository.Repo;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.session.RowBounds;
import org.mybatis.spring.support.SqlSessionDaoSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;

public class Repository
extends SqlSessionDaoSupport
implements Repo {
    private static final Logger LOGGER = LoggerFactory.getLogger(Repository.class);
    private static final String LOADTOTAL = "loadTotal";

    @Override
    public <T> T selectOne(String statement, Object parameter) {
        return (T)this.getSqlSession().selectOne(statement, parameter);
    }

    @Override
    public <E> List<E> selectList(String statement, Object parameter) {
        return this.getSqlSession().selectList(statement, parameter);
    }

    @Override
    public <T> Page<T> selectPaging(String statement, Object parameter, int offset, int limit) {
        RowBounds rowBounds = new RowBounds(offset, limit);
        List rows = this.getSqlSession().selectList(statement, parameter, rowBounds);
        int total = PaginationInterceptor.getPaginationTotal();
        PageRequest pageable = new PageRequest(offset, limit);
        return new PageImpl(rows, (Pageable)pageable, (long)total);
    }

    @Override
    public <T> Page<T> selectPaging(String statement, Object parameter, Pageable pageable) {
        RowBounds rowBounds = new RowBounds(pageable.getPageNumber(), pageable.getPageSize());
        Map map = new HashMap();
        if (parameter != null) {
            map = (Map)JSONObject.parseObject((String)JSONObject.toJSONString((Object)parameter), Map.class);
        }
        List rows = this.getSqlSession().selectList(statement, (Object)this.orderBySort(pageable, map), rowBounds);
        int total = PaginationInterceptor.getPaginationTotal();
        if (total == -1) {
            total = CollectionUtils.isNotEmpty((Collection)rows) ? (rows.size() == pageable.getPageSize() ? (pageable.getPageNumber() + 1) * pageable.getPageSize() + 1 : (pageable.getPageNumber() + 1) * pageable.getPageSize()) : 0;
        }
        return new PageImpl(rows, pageable, (long)total);
    }

    @Override
    public <T> Page<T> selectPaging(String statement, Object parameter, Pageable pageable, String flag) {
        RowBounds rowBounds = new RowBounds(pageable.getPageNumber(), pageable.getPageSize());
        List rows = this.getSqlSession().selectList(statement, parameter, rowBounds);
        JSONArray arr = new JSONArray();
        for (Object t : rows) {
            JSONObject obj = new JSONObject((Map)t);
            arr.add((Object)obj);
        }
        ArrayList result = new ArrayList();
        for (int i = 0; i < arr.size(); ++i) {
            JSONObject temp = arr.getJSONObject(i);
            HashMap map = new HashMap();
            for (Map.Entry entry : temp.entrySet()) {
                if (null == entry.getValue() || "".equals(entry.getValue())) {
                    map.put(entry.getKey(), "");
                    continue;
                }
                map.put(entry.getKey(), (String)entry.getValue());
            }
            result.add(map);
        }
        int total = PaginationInterceptor.getPaginationTotal();
        return new PageImpl(result, pageable, (long)total);
    }

    @Override
    public <K, V> Map<K, V> selectMap(String statement, Object parameter, String mapKey) {
        return this.getSqlSession().selectMap(statement, parameter, mapKey);
    }

    @Override
    public int insert(String statement, Object parameter) {
        return this.getSqlSession().insert(statement, parameter);
    }

    @Override
    public int update(String statement, Object parameter) {
        return this.getSqlSession().update(statement, parameter);
    }

    @Override
    public int delete(String statement, Object parameter) {
        return this.getSqlSession().delete(statement, parameter);
    }

    public Map orderBySort(Pageable pageable, Map map) {
        if (pageable != null && pageable.getSort() != null) {
            String sortParameter = "";
            String sort = String.valueOf(pageable.getSort());
            String disposeSort = this.HumpToUnderline(sort.replace(":", ""));
            if (disposeSort.indexOf("_A_S_C") != -1) {
                sortParameter = disposeSort.replace("_A_S_C", "ASC");
            }
            if (disposeSort.indexOf("_D_E_S_C") != -1) {
                sortParameter = disposeSort.replace("_D_E_S_C", "DESC");
            }
            map.put("sort", sortParameter);
        }
        return map;
    }

    public String HumpToUnderline(String para) {
        StringBuilder sb = new StringBuilder(para);
        int temp = 0;
        for (int i = 0; i < para.length(); ++i) {
            if (!Character.isUpperCase(para.charAt(i))) continue;
            sb.insert(i + temp, "_");
            ++temp;
        }
        return sb.toString().toUpperCase();
    }
}

