/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.core.support.mybatis.page.helper;

import cn.gtmap.realestate.common.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.common.core.support.mybatis.page.dialect.Dialect;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SqlHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityMapper.class);

    private SqlHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCount(MappedStatement ms, Connection connection, Object parameterObject, Dialect dialect) throws SQLException {
        BoundSql boundSql = ms.getBoundSql(parameterObject);
        String countSql = dialect.getCountString(boundSql.getSql());
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(countSql);
            DefaultParameterHandler handler = new DefaultParameterHandler(ms, parameterObject, boundSql);
            handler.setParameters(preparedStatement);
            resultSet = preparedStatement.executeQuery();
            int count = 0;
            if (resultSet.next()) {
                count = resultSet.getInt(1);
            }
            int n = count;
            return n;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            SqlHelper.closeStatement(preparedStatement);
        }
    }

    private static void closeStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

