/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.core.support.mybatis.page.dialect;

import cn.gtmap.realestate.common.core.support.mybatis.page.dialect.Dialect;
import org.apache.commons.lang3.StringUtils;

public class SqlServerDialect
extends Dialect {
    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public String getLimitString(String sql, int offset, int limit) {
        return this.getLimitStringPrivate(sql, offset, limit);
    }

    private String getLimitStringPrivate(String querySqlString, int offset, int limit) {
        StringBuilder pagingBuilder = new StringBuilder();
        String orderby = SqlServerDialect.getOrderByPart(querySqlString);
        String distinctStr = "";
        String loweredString = querySqlString.toLowerCase();
        String sqlPartString = querySqlString;
        if (loweredString.trim().startsWith("select")) {
            int index = 6;
            if (loweredString.startsWith("select distinct")) {
                distinctStr = "DISTINCT ";
                index = 15;
            }
            sqlPartString = sqlPartString.substring(index);
        }
        pagingBuilder.append(sqlPartString);
        if (StringUtils.isBlank((CharSequence)orderby)) {
            orderby = "ORDER BY CURRENT_TIMESTAMP";
        }
        StringBuilder result = new StringBuilder();
        result.append("WITH query AS (SELECT ").append(distinctStr).append("TOP 100 PERCENT ").append(" ROW_NUMBER() OVER (").append(orderby).append(") as __row_number__, ").append((CharSequence)pagingBuilder).append(") SELECT * FROM query WHERE __row_number__ BETWEEN ").append(offset + 1).append(" AND ").append(offset + limit).append(" ORDER BY __row_number__");
        return result.toString();
    }

    private static String getOrderByPart(String sql) {
        String loweredString = sql.toLowerCase();
        int orderByIndex = loweredString.indexOf("order by");
        if (orderByIndex != -1) {
            return sql.substring(orderByIndex);
        }
        return "";
    }
}

