/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.core.support.mybatis.mapper;

import cn.gtmap.realestate.common.core.support.mybatis.mapper.BaseProvider;
import cn.gtmap.realestate.common.core.support.mybatis.mapper.EntityHelper;
import cn.gtmap.realestate.common.core.support.mybatis.mapper.MapperTemplate;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.jdbc.SQL;
import org.apache.ibatis.reflection.MetaObject;

public class CommonProvider
extends BaseProvider {
    private static final String RECORDMARK = "=#{record.";
    private static final String RECORD = "record";

    public String select(Map<String, Object> params) {
        SQL sql = new SQL();
        Object entity = this.getEntity(params);
        Class<?> entityClass = this.getEntityClass(params);
        EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        sql.SELECT(EntityHelper.getAllColumns(entityClass));
        sql.FROM(entityTable.getName());
        if (entity != null) {
            MetaObject metaObject = MapperTemplate.forObject(entity);
            for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                Object value = metaObject.getValue(column.getProperty());
                if (value == null) continue;
                if (column.getJavaType().equals(String.class)) {
                    if (!this.isNotEmpty((String)value)) continue;
                    sql.WHERE(column.getColumn() + RECORDMARK + column.getProperty() + "}");
                    continue;
                }
                sql.WHERE(column.getColumn() + RECORDMARK + column.getProperty() + "}");
            }
        }
        StringBuilder orderBy = new StringBuilder();
        for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
            if (column.getOrderBy() == null) continue;
            orderBy.append(column.getColumn()).append(" ").append(column.getOrderBy()).append(",");
        }
        if (orderBy.length() > 0) {
            sql.ORDER_BY(orderBy.substring(0, orderBy.length() - 1));
        }
        return sql.toString();
    }

    public String count(Map<String, Object> params) {
        Class<?> entityClass;
        SQL sql = new SQL();
        Object entity = this.getEntity(params);
        if (entity instanceof Class) {
            entityClass = (Class<?>)entity;
            entity = null;
        } else {
            entityClass = this.getEntityClass(params);
        }
        EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        sql.SELECT("count(*)");
        sql.FROM(entityTable.getName());
        if (entity != null) {
            MetaObject metaObject = MapperTemplate.forObject(entity);
            for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                Object value = metaObject.getValue(column.getProperty());
                if (value == null) continue;
                if (column.getJavaType().equals(String.class)) {
                    if (!this.isNotEmpty((String)value)) continue;
                    sql.WHERE(column.getColumn() + RECORDMARK + column.getProperty() + "}");
                    continue;
                }
                sql.WHERE(column.getColumn() + RECORDMARK + column.getProperty() + "}");
            }
        }
        return sql.toString();
    }

    public String selectByPrimaryKey(Map<String, Object> params) {
        SQL sql = new SQL();
        Object entity = this.getEntity(params);
        Class<?> entityClass = this.getEntityClass(params);
        EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        sql.SELECT(EntityHelper.getAllColumns(entityClass));
        sql.FROM(entityTable.getName());
        if (entityTable.getEntityClassPKColumns().size() == 1) {
            EntityHelper.EntityColumn column = entityTable.getEntityClassPKColumns().iterator().next();
            this.notNullKeyProperty(column.getProperty(), entity);
            sql.WHERE(column.getColumn() + "=#{key}");
        } else {
            MetaObject metaObject = MapperTemplate.forObject(entity);
            for (EntityHelper.EntityColumn column : entityTable.getEntityClassPKColumns()) {
                Object value = metaObject.getValue(column.getProperty());
                this.notNullKeyProperty(column.getProperty(), value);
                sql.WHERE(column.getColumn() + "=#{key." + column.getProperty() + "}");
            }
        }
        return sql.toString();
    }

    public String insert(Map<String, Object> params) {
        SQL sql = new SQL();
        Class<?> entityClass = this.getEntityClass(params);
        EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        sql.INSERT_INTO(entityTable.getName());
        for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
            sql.VALUES(column.getColumn(), "#{record." + column.getProperty() + "}");
        }
        return sql.toString();
    }

    public String insertSelective(Map<String, Object> params) {
        SQL sql = new SQL();
        Object entity = this.getEntity(params);
        Class<?> entityClass = this.getEntityClass(params);
        EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        MetaObject metaObject = MapperTemplate.forObject(entity);
        sql.INSERT_INTO(entityTable.getName());
        for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
            Object value = metaObject.getValue(column.getProperty());
            if (!column.isId() && value == null) continue;
            sql.VALUES(column.getColumn(), "#{record." + column.getProperty() + "}");
        }
        return sql.toString();
    }

    public String insertBatchSelective(Map<String, Object> params) {
        String insertBatchSql = "";
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        Class<?> entityClass = this.getEntityClass(params);
        EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        insertBatchSql = insertBatchSql + "insert into " + entityTable.getName();
        if (params.containsKey(RECORD) && params.get(RECORD) != null && (params.get(RECORD) instanceof List || params.get(RECORD) instanceof ArrayList)) {
            List list = (List)params.get(RECORD);
            for (int i = 0; i < list.size(); ++i) {
                StringBuffer sbf = new StringBuffer("select ");
                int j = 0;
                for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
                    ++j;
                    if (i == 0) {
                        columns.add(column.getColumn());
                    }
                    String type = this.getjdbcType(column.getJavaType().getSimpleName());
                    if (j == entityTable.getEntityClassColumns().size()) {
                        sbf.append("#{record[" + i + "]." + column.getProperty() + "," + type + "}");
                        continue;
                    }
                    sbf.append("#{record[" + i + "]." + column.getProperty() + "," + type + "},");
                }
                sbf.append(" from dual");
                values.add(sbf.toString());
            }
        }
        insertBatchSql = insertBatchSql + " " + this.batchSql(columns, ",");
        insertBatchSql = insertBatchSql + " " + this.batchSql(values, "union all");
        return insertBatchSql;
    }

    private String batchSql(List<?> list, String split) {
        StringBuffer sbf = new StringBuffer("(");
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                sbf.append(list.get(i)).append(" ");
                if (list.size() - i == 1) continue;
                sbf.append(split).append(" ");
            }
        }
        sbf.append(")");
        return sbf.toString();
    }

    private String getjdbcType(String type) {
        String str = "";
        if (StringUtils.equals((CharSequence)type.toUpperCase(), (CharSequence)"DATE")) {
            str = "jdbcType=TIMESTAMP";
        }
        if (StringUtils.equals((CharSequence)type.toUpperCase(), (CharSequence)"STRING")) {
            str = "jdbcType=VARCHAR";
        }
        if (StringUtils.equals((CharSequence)type.toUpperCase(), (CharSequence)"INTEGER")) {
            str = "jdbcType=INTEGER";
        }
        if (StringUtils.equals((CharSequence)type.toUpperCase(), (CharSequence)"DOUBLE")) {
            str = "jdbcType=DOUBLE";
        }
        if (StringUtils.equals((CharSequence)type.toUpperCase(), (CharSequence)"FLOAT")) {
            str = "jdbcType=FLOAT";
        }
        return str;
    }

    public String delete(Map<String, Object> params) {
        SQL sql = new SQL();
        Object entity = this.getEntity(params);
        Class<?> entityClass = this.getEntityClass(params);
        EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        MetaObject metaObject = MapperTemplate.forObject(entity);
        sql.DELETE_FROM(entityTable.getName());
        boolean hasValue = false;
        for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
            Object value = metaObject.getValue(column.getProperty());
            if (value == null) continue;
            if (column.getJavaType().equals(String.class)) {
                if (!this.isNotEmpty((String)value)) continue;
                sql.WHERE(column.getColumn() + RECORDMARK + column.getProperty() + "}");
                hasValue = true;
                continue;
            }
            sql.WHERE(column.getColumn() + RECORDMARK + column.getProperty() + "}");
            hasValue = true;
        }
        if (!hasValue) {
            throw new UnsupportedOperationException("delete\u65b9\u6cd5\u4e0d\u652f\u6301\u5220\u9664\u5168\u8868\u7684\u64cd\u4f5c!");
        }
        return sql.toString();
    }

    public String deleteByPrimaryKey(Map<String, Object> params) {
        SQL sql = new SQL();
        Object entity = this.getEntity(params);
        Class<?> entityClass = this.getEntityClass(params);
        EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        sql.DELETE_FROM(entityTable.getName());
        if (entityTable.getEntityClassPKColumns().size() == 1) {
            EntityHelper.EntityColumn column = entityTable.getEntityClassPKColumns().iterator().next();
            this.notNullKeyProperty(column.getProperty(), entity);
            sql.WHERE(column.getColumn() + "=#{key}");
        } else {
            MetaObject metaObject = MapperTemplate.forObject(entity);
            for (EntityHelper.EntityColumn column : entityTable.getEntityClassPKColumns()) {
                Object value = metaObject.getValue(column.getProperty());
                this.notNullKeyProperty(column.getProperty(), value);
                sql.WHERE(column.getColumn() + "=#{key." + column.getProperty() + "}");
            }
        }
        return sql.toString();
    }

    public String updateByPrimaryKey(Map<String, Object> params) {
        SQL sql = new SQL();
        Object entity = this.getEntity(params);
        Class<?> entityClass = this.getEntityClass(params);
        EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        MetaObject metaObject = MapperTemplate.forObject(entity);
        sql.UPDATE(entityTable.getName());
        for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
            if (column.isId()) continue;
            sql.SET(column.getColumn() + RECORDMARK + column.getProperty() + "}");
        }
        if (entityTable.getEntityClassPKColumns().size() == 1) {
            EntityHelper.EntityColumn column = entityTable.getEntityClassPKColumns().iterator().next();
            this.notNullKeyProperty(column.getProperty(), metaObject.getValue(column.getProperty()));
            sql.WHERE(column.getColumn() + RECORDMARK + column.getProperty() + "}");
        } else {
            for (EntityHelper.EntityColumn column : entityTable.getEntityClassPKColumns()) {
                Object value = metaObject.getValue(column.getProperty());
                this.notNullKeyProperty(column.getProperty(), value);
                sql.WHERE(column.getColumn() + RECORDMARK + column.getProperty() + "}");
            }
        }
        return sql.toString();
    }

    public String updateByPrimaryKeyNull(Map<String, Object> params) {
        SQL sql = new SQL();
        Object entity = this.getEntity(params);
        Class<?> entityClass = this.getEntityClass(params);
        EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        MetaObject metaObject = MapperTemplate.forObject(entity);
        sql.UPDATE(entityTable.getName());
        for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
            String type = this.getjdbcType(column.getJavaType().getSimpleName());
            if (column.isId()) continue;
            sql.SET(column.getColumn() + RECORDMARK + column.getProperty() + "," + type + "}");
        }
        if (entityTable.getEntityClassPKColumns().size() == 1) {
            EntityHelper.EntityColumn column = entityTable.getEntityClassPKColumns().iterator().next();
            this.notNullKeyProperty(column.getProperty(), metaObject.getValue(column.getProperty()));
            sql.WHERE(column.getColumn() + RECORDMARK + column.getProperty() + "}");
        } else {
            for (EntityHelper.EntityColumn column : entityTable.getEntityClassPKColumns()) {
                Object value = metaObject.getValue(column.getProperty());
                this.notNullKeyProperty(column.getProperty(), value);
                sql.WHERE(column.getColumn() + RECORDMARK + column.getProperty() + "}");
            }
        }
        return sql.toString();
    }

    public String updateByPrimaryKeySelective(Map<String, Object> params) {
        SQL sql = new SQL();
        Object entity = this.getEntity(params);
        Class<?> entityClass = this.getEntityClass(params);
        EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        MetaObject metaObject = MapperTemplate.forObject(entity);
        sql.UPDATE(entityTable.getName());
        for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
            Object value = metaObject.getValue(column.getProperty());
            if (value == null || column.isId()) continue;
            sql.SET(column.getColumn() + RECORDMARK + column.getProperty() + "}");
        }
        if (entityTable.getEntityClassPKColumns().size() == 1) {
            EntityHelper.EntityColumn column = entityTable.getEntityClassPKColumns().iterator().next();
            this.notNullKeyProperty(column.getProperty(), metaObject.getValue(column.getProperty()));
            sql.WHERE(column.getColumn() + RECORDMARK + column.getProperty() + "}");
        } else {
            for (EntityHelper.EntityColumn column : entityTable.getEntityClassPKColumns()) {
                this.notNullKeyProperty(column.getProperty(), metaObject.getValue(column.getProperty()));
                sql.WHERE(column.getColumn() + RECORDMARK + column.getProperty() + "}");
            }
        }
        return sql.toString();
    }

    public String countByExample(Map<String, Object> params) {
        SQL sql = new SQL();
        MetaObject example = this.getExample(params);
        Class<?> entityClass = this.getEntityClass(params);
        EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        sql.SELECT("count(*)");
        sql.FROM(entityTable.getName());
        this.applyWhere(sql, example);
        return sql.toString();
    }

    public String deleteByExample(Map<String, Object> params) {
        SQL sql = new SQL();
        MetaObject example = this.getExample(params);
        Class<?> entityClass = this.getEntityClass(params);
        EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        sql.DELETE_FROM(entityTable.getName());
        this.applyWhere(sql, example);
        return sql.toString();
    }

    public String selectByExample(Map<String, Object> params) {
        SQL sql = new SQL();
        MetaObject example = this.getExample(params);
        Class<?> entityClass = this.getEntityClass(params);
        EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        sql.SELECT(EntityHelper.getAllColumns(entityClass));
        sql.FROM(entityTable.getName());
        this.applyWhere(sql, example);
        this.applyOrderBy(sql, example);
        return sql.toString();
    }

    public String updateByExampleSelective(Map<String, Object> params) {
        SQL sql = new SQL();
        Object entity = this.getEntity(params);
        MetaObject example = this.getExample(params);
        Class<?> entityClass = this.getEntityClass(params);
        EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        MetaObject metaObject = MapperTemplate.forObject(entity);
        sql.UPDATE(entityTable.getName());
        for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
            Object value = metaObject.getValue(column.getProperty());
            if (value == null) continue;
            sql.SET(column.getColumn() + RECORDMARK + column.getProperty() + "}");
        }
        this.applyWhere(sql, example);
        return sql.toString();
    }

    public String updateByExample(Map<String, Object> params) {
        SQL sql = new SQL();
        MetaObject example = this.getExample(params);
        Class<?> entityClass = this.getEntityClass(params);
        EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        sql.UPDATE(entityTable.getName());
        for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
            if (column.isId()) continue;
            sql.SET(column.getColumn() + RECORDMARK + column.getProperty() + "}");
        }
        this.applyWhere(sql, example);
        return sql.toString();
    }

    public String updateByJsonEntity(Map<String, Object> params) {
        SQL sql = new SQL();
        Object entity = this.getEntity(params);
        Class<?> entityClass = this.getEntityClass(params);
        JSONObject jsonObject = this.getJSONObject(params);
        Set keySet = jsonObject.keySet();
        EntityHelper.EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        MetaObject metaObject = MapperTemplate.forObject(entity);
        sql.UPDATE(entityTable.getName());
        for (EntityHelper.EntityColumn column : entityTable.getEntityClassColumns()) {
            String type = this.getjdbcType(column.getJavaType().getSimpleName());
            if (column.isId() || !keySet.contains(column.getProperty())) continue;
            sql.SET(column.getColumn() + RECORDMARK + column.getProperty() + "," + type + "}");
        }
        if (entityTable.getEntityClassPKColumns().size() == 1) {
            EntityHelper.EntityColumn column = entityTable.getEntityClassPKColumns().iterator().next();
            this.notNullKeyProperty(column.getProperty(), metaObject.getValue(column.getProperty()));
            sql.WHERE(column.getColumn() + RECORDMARK + column.getProperty() + "}");
        } else {
            for (EntityHelper.EntityColumn column : entityTable.getEntityClassPKColumns()) {
                Object value = metaObject.getValue(column.getProperty());
                this.notNullKeyProperty(column.getProperty(), value);
                sql.WHERE(column.getColumn() + RECORDMARK + column.getProperty() + "}");
            }
        }
        return sql.toString();
    }
}

