/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.core.support.mybatis.mapper;

import cn.gtmap.realestate.common.core.support.mybatis.mapper.EntityMapper;
import java.io.UnsupportedEncodingException;
import java.sql.Blob;
import java.sql.SQLException;
import org.apache.commons.beanutils.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobConvert
implements Converter {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityMapper.class);

    public Object convert(Class type, Object value) {
        byte[] result = null;
        if (value == null) {
            return null;
        }
        if (value instanceof Blob) {
            try {
                Blob blob = (Blob)value;
                result = blob.getBytes(1L, (int)blob.length());
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        } else if (value instanceof byte[]) {
            result = (byte[])value;
        } else {
            try {
                result = value.toString().getBytes("utf-8");
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            if (result == null || result.length == 0) {
                return null;
            }
        }
        return result;
    }
}

