/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.core.support.log;

import cn.gtmap.gtc.sso.domain.dto.UserDto;
import cn.gtmap.gtc.starter.gscas.audit.ZipkinAuditEventRepository;
import cn.gtmap.realestate.common.util.UserManagerUtils;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.audit.AuditEvent;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/v1.0/log"})
public class BdcLogInfoController {
    private static final Logger LOGGER = LoggerFactory.getLogger(BdcLogInfoController.class);
    @Autowired
    private UserManagerUtils userManagerUtils;
    @Autowired
    private ZipkinAuditEventRepository zipkinAuditEventRepository;

    @PostMapping(value={"/info"})
    public void saveLogInfo(@RequestBody Map<String, Object> logInfoMap) {
        if (MapUtils.isEmpty(logInfoMap) || StringUtils.isBlank((CharSequence)MapUtils.getString(logInfoMap, (Object)"logType"))) {
            LOGGER.error("\u4fdd\u5b58\u65e5\u5fd7\u4fe1\u606f\u4e2d\u6b62\uff0c\u56e0\u4e3a\u65e5\u5fd7\u53c2\u6570\u4fe1\u606f\u4e3a\u7a7a");
            return;
        }
        String userAlias = MapUtils.getString(logInfoMap, (Object)"userAlias");
        String userName = MapUtils.getString(logInfoMap, (Object)"userName");
        if (StringUtils.isBlank((CharSequence)userAlias) || StringUtils.isBlank((CharSequence)userName)) {
            UserDto userDto = this.userManagerUtils.getCurrentUser();
            userAlias = userDto == null ? "" : userDto.getAlias();
            logInfoMap.put("alias", userAlias);
            userName = userDto == null ? "" : userDto.getUsername();
            logInfoMap.put("userName", userName);
        }
        try {
            String logType = MapUtils.getString(logInfoMap, (Object)"logType");
            this.zipkinAuditEventRepository.newSpanTag(new AuditEvent(userName, logType, logInfoMap), logType);
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u65e5\u5fd7\u4fe1\u606f\u51fa\u9519\uff1a{}", (Object)e.getMessage());
        }
    }
}

