/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.core.support.gxhpz;

import cn.gtmap.realestate.common.core.ex.AppException;
import cn.gtmap.realestate.common.util.RedisUtils;
import cn.gtmap.realestate.common.util.UserManagerUtils;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/v1.0/gxhpz"})
public class CommonGxhpzController {
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private UserManagerUtils userManagerUtils;

    @ResponseBody
    @PostMapping(value={"/save/table"})
    public String gxhpzSave(@RequestBody List<Map> gxhList, @RequestParam(value="tableid") String tableid, @RequestParam(value="url") String url) {
        return this.gxhpzSave(gxhList, tableid, url, "table");
    }

    @ResponseBody
    @PostMapping(value={"/save/form"})
    public String gxhpzSaveForm(@RequestBody List<Map> gxhList, @RequestParam(value="formid") String formid, @RequestParam(value="url") String url) {
        return this.gxhpzSave(gxhList, formid, url, "form");
    }

    @ResponseBody
    @GetMapping(value={"/query/table"})
    public String gxhpzQuery(@RequestParam(value="tableid") String tableid, @RequestParam(value="url") String url) {
        JSONObject configObject;
        String configJson = this.queryGxhpz(url);
        if (StringUtils.isNotEmpty((CharSequence)configJson) && StringUtils.isNotEmpty((CharSequence)(configObject = JSONObject.parseObject((String)configJson)).getString("table"))) {
            return configObject.getJSONObject("table").getString(tableid);
        }
        return null;
    }

    @ResponseBody
    @GetMapping(value={"/query/form"})
    public String gxhpzQueryForm(@RequestParam(value="formid") String formid, @RequestParam(value="url") String url) {
        JSONObject configObject;
        String configJson = this.queryGxhpz(url);
        if (StringUtils.isNotEmpty((CharSequence)configJson) && StringUtils.isNotEmpty((CharSequence)(configObject = JSONObject.parseObject((String)configJson)).getString("form"))) {
            return configObject.getJSONObject("form").getString(formid);
        }
        return null;
    }

    private String gxhpzSave(List<Map> gxhList, String tableid, String url, String type) {
        String gxhJson;
        JSONObject table;
        if (gxhList == null || StringUtils.isBlank((CharSequence)url)) {
            throw new AppException("\u53c2\u6570\u7f3a\u5931\uff0c\u65e0\u6cd5\u4fdd\u5b58\u4e2a\u6027\u5316\u914d\u7f6e\uff01");
        }
        String json = this.queryGxhpz(url);
        if (StringUtils.isNotEmpty((CharSequence)json)) {
            JSONObject gxhpz = JSONObject.parseObject((String)json);
            if (StringUtils.isNotEmpty((CharSequence)gxhpz.getString(type))) {
                table = gxhpz.getJSONObject(type);
                table.put(tableid, gxhList);
                gxhpz.put(type, (Object)table);
            } else {
                table = new JSONObject();
                table.put(tableid, gxhList);
                gxhpz.put(type, (Object)table);
            }
            gxhJson = gxhpz.toJSONString();
        } else {
            JSONObject config = new JSONObject();
            table = new JSONObject();
            table.put(tableid, gxhList);
            config.put(type, (Object)table);
            gxhJson = config.toJSONString();
        }
        String username = this.userManagerUtils.getCurrentUserName();
        String key = username + url;
        return this.redisUtils.setStringValue(key, gxhJson);
    }

    private String queryGxhpz(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new AppException("\u53c2\u6570\u7f3a\u5931\uff0c\u65e0\u6cd5\u83b7\u5f97\u4e2a\u6027\u5316\u914d\u7f6e\uff01");
        }
        String username = this.userManagerUtils.getCurrentUserName();
        String key = username + url;
        return this.redisUtils.getStringValue(key);
    }
}

