/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.core.support.excel;

import cn.gtmap.realestate.common.core.dto.ExcelExportDTO;
import cn.gtmap.realestate.common.util.StringToolUtils;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/excel"})
public class ExcelController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelController.class);
    private static final String CLASS_NAME = ExcelController.class.getName();

    @PostMapping(value={"/export"})
    public void exportExcel(HttpServletResponse response, @ModelAttribute ExcelExportDTO excelExportDTO) {
        if (null == excelExportDTO || this.isExistEmpty(excelExportDTO)) {
            LOGGER.error("{}\uff1a\u5bfc\u51faExcel\u4e2d\u6b62\uff0c\u539f\u56e0\uff1a\u63d0\u4ea4\u7684\u6570\u636e\u5b58\u5728\u95ee\u9898\uff01", (Object)CLASS_NAME);
            return;
        }
        if (null == excelExportDTO.getRownum()) {
            excelExportDTO.setRownum(0);
        }
        try (HSSFWorkbook workbook = new HSSFWorkbook();
             ServletOutputStream outputStream = response.getOutputStream();){
            String sheetName = excelExportDTO.getSheetName();
            if (StringUtils.isBlank((CharSequence)sheetName)) {
                sheetName = "\u5de5\u4f5c\u7c3f";
            }
            HSSFSheet sheet = workbook.createSheet(sheetName);
            this.setCellTitle(workbook, sheet, excelExportDTO);
            this.setCellWidth(sheet, excelExportDTO.getCellWidth());
            if (excelExportDTO.getMergeSameCell().booleanValue() && StringUtils.isNotBlank((CharSequence)excelExportDTO.getMergeCellKey())) {
                this.setCellDataAndMergeSameCell(workbook, sheet, excelExportDTO);
            } else {
                this.setCellData(workbook, sheet, excelExportDTO);
            }
            String fileName = URLEncoder.encode(excelExportDTO.getFileName() + ".xls", "utf-8");
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            outputStream.flush();
            workbook.write((OutputStream)outputStream);
        }
        catch (IOException e) {
            LOGGER.error("{}\u7cfb\u7edf\u5bfc\u51faExcel\u62a5\u9519\uff1a{}", (Object)CLASS_NAME, (Object)e.getMessage());
        }
    }

    private boolean isExistEmpty(ExcelExportDTO excelExportDTO) {
        return StringToolUtils.existItemNullOrEmpty(excelExportDTO.getFileName(), excelExportDTO.getCellTitle(), excelExportDTO.getCellKey(), excelExportDTO.getData());
    }

    private void setCellTitle(HSSFWorkbook workbook, HSSFSheet sheet, ExcelExportDTO excelExportDTO) {
        int rowNum = excelExportDTO.getRownum();
        String title = excelExportDTO.getCellTitle();
        String[] cellTitleArr = title.split(",");
        HSSFCellStyle style = workbook.createCellStyle();
        HSSFFont font = workbook.createFont();
        font.setBold(true);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setFont(font);
        HSSFRow rowTableName = sheet.createRow(rowNum);
        HSSFCell cellTableName = rowTableName.createCell(0);
        cellTableName.setCellValue(sheet.getSheetName());
        cellTableName.setCellStyle(style);
        sheet.addMergedRegion(new CellRangeAddress(rowNum, rowNum, 0, cellTitleArr.length - 1));
        ++rowNum;
        if (StringUtils.isNotBlank((CharSequence)excelExportDTO.getSummaryContent())) {
            String[] summaryArr = excelExportDTO.getSummaryContent().split(",");
            Integer cellNum = 0;
            if (summaryArr.length > 1 && NumberUtils.isNumber((String)summaryArr[1])) {
                cellNum = Integer.parseInt(summaryArr[1]);
            }
            rowTableName = sheet.createRow(rowNum);
            cellTableName = rowTableName.createCell(cellNum.intValue());
            cellTableName.setCellValue(summaryArr[0]);
            sheet.addMergedRegion(new CellRangeAddress(rowNum, rowNum, cellNum.intValue(), cellTitleArr.length - 1));
            ++rowNum;
        }
        HSSFRow rowTitle = sheet.createRow(rowNum);
        for (int i = 0; i < cellTitleArr.length; ++i) {
            HSSFCell cell = rowTitle.createCell(i);
            cell.setCellValue(cellTitleArr[i]);
            cell.setCellStyle(style);
        }
        excelExportDTO.setRownum(++rowNum);
    }

    private void setCellWidth(HSSFSheet sheet, String width) {
        if (StringUtils.isBlank((CharSequence)width)) {
            return;
        }
        String[] cellWidthArr = width.split(",");
        for (int i = 0; i < cellWidthArr.length; ++i) {
            sheet.setColumnWidth(i, Integer.valueOf(cellWidthArr[i]) * 256);
        }
    }

    private void setCellData(HSSFWorkbook workbook, HSSFSheet sheet, ExcelExportDTO excelExportDTO) {
        List dataList = (List)JSON.parseObject((String)excelExportDTO.getData(), List.class);
        String[] cellKeyArr = excelExportDTO.getCellKey().split(",");
        HSSFCellStyle dataCellStyle = workbook.createCellStyle();
        dataCellStyle.setAlignment(HorizontalAlignment.CENTER);
        int rowNum = excelExportDTO.getRownum();
        for (int j = 0; j < dataList.size(); ++j) {
            HSSFRow dataRow = sheet.createRow(j + rowNum);
            Map map = (Map)dataList.get(j);
            int cellNum = 0;
            for (String cellKey : cellKeyArr) {
                String value = "";
                if (map.containsKey(cellKey) && null != map.get(cellKey)) {
                    value = String.valueOf(map.get(cellKey));
                }
                HSSFCell dataCell = dataRow.createCell(cellNum++);
                dataCell.setCellValue(value);
                dataCell.setCellStyle(dataCellStyle);
            }
        }
    }

    private void setCellDataAndMergeSameCell(HSSFWorkbook workbook, HSSFSheet sheet, ExcelExportDTO excelExportDTO) {
        List dataList = (List)JSON.parseObject((String)excelExportDTO.getData(), List.class);
        String[] cellKeyArr = excelExportDTO.getCellKey().split(",");
        HSSFCellStyle dataCellStyle = workbook.createCellStyle();
        dataCellStyle.setAlignment(HorizontalAlignment.CENTER);
        dataCellStyle.getVerticalAlignmentEnum();
        dataCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        int startRowNum = excelExportDTO.getRownum();
        HashMap<String, Integer> tempMap = new HashMap<String, Integer>(1);
        List<String> mergeCellArr = Arrays.asList(excelExportDTO.getMergeCellKey().split(","));
        int rowNum = 0;
        int next = 1;
        while (rowNum < dataList.size()) {
            int currentRowNum = rowNum + startRowNum;
            HSSFRow dataRow = sheet.createRow(currentRowNum);
            Map map = (Map)dataList.get(rowNum);
            Map nextDataMap = next == dataList.size() ? (Map)dataList.get(0) : (Map)dataList.get(next);
            for (int colNum = 0; colNum < cellKeyArr.length; ++colNum) {
                String cellKey = cellKeyArr[colNum];
                String value = "";
                if (map.containsKey(cellKey) && null != map.get(cellKey)) {
                    value = String.valueOf(map.get(cellKey));
                }
                HSSFCell dataCell = dataRow.createCell(colNum);
                dataCell.setCellValue(value);
                dataCell.setCellStyle(dataCellStyle);
                if (!mergeCellArr.contains(cellKey) || !nextDataMap.containsKey(cellKey)) continue;
                String nextData = String.valueOf(nextDataMap.get(cellKey));
                this.mergeCell(sheet, currentRowNum, colNum, value, cellKey, nextData, mergeCellArr, tempMap);
            }
            ++rowNum;
            ++next;
        }
    }

    private void mergeCell(HSSFSheet sheet, int currentRowNum, int currentColNum, String cellValue, String cellKey, String nextData, List<String> mergeCellArr, Map<String, Integer> tempMap) {
        if (cellValue.equals(nextData)) {
            if (tempMap.containsKey(cellKey)) {
                tempMap.put(cellKey, tempMap.get(cellKey) + 1);
            } else {
                tempMap.put(cellKey, 1);
            }
        } else if (tempMap.containsKey(cellKey) && !tempMap.get(cellKey).equals(0)) {
            sheet.addMergedRegion(new CellRangeAddress(currentRowNum - tempMap.get(cellKey), currentRowNum, currentColNum, currentColNum));
            tempMap.put(cellKey, 0);
        }
    }
}

