/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.core.support.dypz;

import cn.gtmap.realestate.common.core.dto.OfficeExportDTO;
import cn.gtmap.realestate.common.core.ex.AppException;
import cn.gtmap.realestate.common.core.ex.MissingArgumentException;
import cn.gtmap.realestate.common.core.qo.config.BdcPdfDyQO;
import cn.gtmap.realestate.common.core.service.feign.config.BdcDysjPzFeignService;
import cn.gtmap.realestate.common.core.support.pdf.PdfController;
import cn.gtmap.realestate.common.util.RedisUtils;
import cn.gtmap.realestate.common.util.RestRpcUtils;
import cn.gtmap.realestate.common.util.UUIDGenerator;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/v1.0/dypz/common"})
public class DypzController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DypzController.class);
    @Autowired
    private BdcDysjPzFeignService bdcDysjPzFeignService;
    @Autowired
    private PdfController pdfController;
    @Autowired
    private RestRpcUtils restRpcUtils;
    @Autowired
    private RedisUtils redisUtils;

    @PostMapping(value={"/pzxx"})
    public Map getBdcDysjPz(@RequestBody List<String> dylxList) {
        if (CollectionUtils.isEmpty(dylxList)) {
            throw new MissingArgumentException("\u67e5\u8be2\u6253\u5370\u914d\u7f6e\u4fe1\u606f\uff0c\u4f46\u662f\u5f53\u524d\u53c2\u6570 dylxList \u4e3a\u7a7a\u3002\u8bf7\u68c0\u67e5\uff01");
        }
        return this.bdcDysjPzFeignService.queryBdcDysjPzByDylx(dylxList);
    }

    @PostMapping(value={"/pdf/param/redis"})
    public String sendXmlToRedis(@RequestBody BdcPdfDyQO bdcPdfDyQO) {
        return this.redisUtils.addStringValue(UUIDGenerator.generate16(), JSONObject.toJSONString((Object)bdcPdfDyQO), 60L);
    }

    @GetMapping(value={"/pdf/{redisKey}"})
    public void getPdfViewData(HttpServletResponse response, @PathVariable(value="redisKey") String redisKey) {
        String paramJson = this.redisUtils.getStringValue(redisKey);
        BdcPdfDyQO bdcPdfDyQO = (BdcPdfDyQO)JSONObject.parseObject((String)paramJson, BdcPdfDyQO.class);
        if (null == bdcPdfDyQO) {
            throw new AppException("PDF\u6253\u5370\u9884\u89c8\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u672a\u83b7\u53d6\u5230\u53c2\u6570\u4fe1\u606f\uff01");
        }
        String xmlData = this.getPrintDataXml(bdcPdfDyQO);
        if (StringUtils.isBlank((CharSequence)xmlData)) {
            throw new MissingArgumentException("\u8bc1\u660e\u5355\u5bfc\u51fapdf\u4e2d\u6b62\uff0c\u539f\u56e0\uff1a\u672a\u83b7\u53d6\u5230\u6570\u636e\u4fe1\u606f\uff01");
        }
        OfficeExportDTO pdfExportDTO = new OfficeExportDTO();
        pdfExportDTO.setModelName(bdcPdfDyQO.getPdfpath());
        pdfExportDTO.setFileName(bdcPdfDyQO.getFileName());
        pdfExportDTO.setXmlData(xmlData);
        this.pdfController.exportPdf(response, pdfExportDTO);
    }

    @GetMapping(value={"/xml"})
    public String getPrintDataXml(BdcPdfDyQO bdcPdfDyQO) {
        try {
            String result = (String)this.restRpcUtils.getRpcRequest(bdcPdfDyQO.getAppName(), bdcPdfDyQO.getDataUrl(), null);
            return result;
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u6253\u5370\u7684xml\u4fe1\u606f,\u6267\u884cGET\u65b9\u5f0f\u8bf7\u6c42RPC\u8c03\u7528\u53d1\u751f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new AppException("\u83b7\u53d6\u6253\u5370\u7684xml\u4fe1\u606f,\u6267\u884cGET\u65b9\u5f0f\u8bf7\u6c42RPC\u8c03\u7528\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }
}

