/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.core.service.rest.building;

import cn.gtmap.realestate.common.core.dto.building.ImportLpbRequestDTO;
import cn.gtmap.realestate.common.core.dto.building.ResourceDTO;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

public interface LpbRestService {
    @GetMapping(value={"/building/rest/v1.0/lpb/refresh"})
    public void refreshLpbConfig(@RequestParam(name="code", required=false) String var1);

    @GetMapping(value={"/building/rest/v1.0/{code}/{fwDcbIndex}/fwhs"}, produces={"application/hal+json"})
    public ResourceDTO queryFwHsListByFwDcbIndex(@PathVariable(value="fwDcbIndex") String var1, @PathVariable(value="code") String var2);

    @GetMapping(value={"/building/rest/v1.0/{code}/{fwDcbIndex}/fwychs"}, produces={"application/hal+json"})
    public ResourceDTO queryFwYchsListByFwDcbIndex(@PathVariable(value="fwDcbIndex") String var1, @PathVariable(value="code") String var2);

    @GetMapping(value={"/building/rest/v1.0/{code}/fwhs/{fwHsIndex}"}, produces={"application/hal+json"})
    public ResourceDTO queryFwHsByIndex(@PathVariable(value="fwHsIndex") String var1, @PathVariable(value="code") String var2);

    @PostMapping(value={"/building/rest/v1.0/lpb/import"})
    public void importLpbInfo(@RequestBody ImportLpbRequestDTO var1);

    @PostMapping(value={"/building/rest/v1.0/lpb/import/yc"})
    public void importYcLpbInfo(@RequestBody ImportLpbRequestDTO var1);

    @PostMapping(value={"/building/rest/v1.0/scmj/import"})
    public void importScmj(@RequestBody ImportLpbRequestDTO var1);

    @PostMapping(value={"/building/rest/v1.0/lpb/export"})
    public List<Map<String, Object>> exportLpb(@RequestParam(name="fwDcbIndex", required=false) String var1);

    @GetMapping(value={"/building/rest/v1.0/lpb/configres/{code}/{fwDcbIndex}"})
    public ResourceDTO getLpbConfigInfoResource(@PathVariable(value="fwDcbIndex") String var1, @PathVariable(value="code") String var2);

    @GetMapping(value={"/building/rest/v1.0/lpb/hsres/{code}/{fwDcbIndex}"})
    public List<ResourceDTO> getFwHsResList(@PathVariable(value="fwDcbIndex") String var1, @PathVariable(value="code") String var2);

    @GetMapping(value={"/building/rest/v1.0/lpb/ychsres/{code}/{fwDcbIndex}"})
    public List<ResourceDTO> getFwYchsResList(@PathVariable(value="fwDcbIndex") String var1, @PathVariable(value="code") String var2);

    @GetMapping(value={"/building/rest/v1.0/lpb/color/pz"})
    public Map<String, Object> getLpbColorPz();
}

