/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.core.service.Impl;

import cn.gtmap.realestate.common.core.ex.AppException;
import cn.gtmap.realestate.common.core.service.HttpClientService;
import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HttpClientServiceImpl
implements HttpClientService {
    protected static Logger LOGGER = LoggerFactory.getLogger(HttpClientServiceImpl.class);
    @Autowired
    private HttpClient httpClient;

    @Override
    public byte[] doGet(String url) throws IOException {
        try (CloseableHttpResponse response = null;){
            HttpGet httpGet = new HttpGet(url);
            response = ((CloseableHttpClient)this.httpClient).execute((HttpUriRequest)httpGet);
            if (response != null && 200 == response.getStatusLine().getStatusCode()) {
                byte[] byArray = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                return byArray;
            }
            throw new AppException("httpGet\u8bf7\u6c42\u5931\u8d25\uff0c\u54cd\u5e94\u7801\uff1a" + response.getStatusLine().getStatusCode() + "\uff0c\u8bf7\u6c42URL\uff1a" + httpGet.getURI());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String doGet(HttpGet httpGet) throws IOException {
        byte[] resultByte;
        String responseStr;
        block6: {
            responseStr = "";
            resultByte = null;
            try (CloseableHttpResponse response = null;){
                response = ((CloseableHttpClient)this.httpClient).execute((HttpUriRequest)httpGet);
                if (response != null && 200 == response.getStatusLine().getStatusCode()) {
                    resultByte = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                    break block6;
                }
                throw new AppException("httpGet\u8bf7\u6c42\u5931\u8d25\uff0c\u54cd\u5e94\u7801\uff1a" + response.getStatusLine().getStatusCode() + "\uff0c\u8bf7\u6c42URL\uff1a" + httpGet.getURI());
            }
        }
        if (resultByte != null) {
            responseStr = StringUtils.toEncodedString((byte[])resultByte, (Charset)Charsets.UTF_8);
        }
        return responseStr;
    }

    @Override
    public String doPost(HttpPost httpPost, String charset) throws IOException {
        return this.sendRequest((HttpEntityEnclosingRequestBase)httpPost, charset);
    }

    @Override
    public String sendRequest(HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase, String charset) throws IOException {
        try (CloseableHttpResponse response = null;){
            response = ((CloseableHttpClient)this.httpClient).execute((HttpUriRequest)httpEntityEnclosingRequestBase);
            if (response != null && 200 == response.getStatusLine().getStatusCode()) {
                String string = EntityUtils.toString((HttpEntity)response.getEntity(), (String)(StringUtils.isNotBlank((CharSequence)charset) ? charset : "UTF-8"));
                return string;
            }
            throw new AppException("http\u8bf7\u6c42\u5931\u8d25\uff0c\u54cd\u5e94\u7801\uff1a" + response.getStatusLine().getStatusCode() + "\uff0c\u8bf7\u6c42URL\uff1a" + httpEntityEnclosingRequestBase.getURI());
        }
    }

    @Override
    public byte[] doPost(String url, List<NameValuePair> postParams) throws IOException {
        return this.doPost(url, postParams, "utf-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] doPost(String url, List<NameValuePair> postParams, String charset) throws IOException {
        try (CloseableHttpResponse response = null;){
            HttpPost httpPost = new HttpPost(url);
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(postParams, charset));
            response = ((CloseableHttpClient)this.httpClient).execute((HttpUriRequest)httpPost);
            if (response != null && 200 == response.getStatusLine().getStatusCode()) {
                byte[] byArray = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
    }

    @Override
    public InputStream doGetReturnStream(String url) throws IOException {
        byte[] responseBody = this.doGet(url);
        if (responseBody != null) {
            ByteArrayInputStream byteResponseStream = new ByteArrayInputStream(responseBody);
            return byteResponseStream;
        }
        return null;
    }
}

