/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.core.service.Impl;

import cn.gtmap.realestate.common.core.ex.AppException;
import cn.gtmap.realestate.common.core.service.BdcZdGlService;
import cn.gtmap.realestate.common.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.realestate.common.core.support.mybatis.mapper.Example;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BdcZdGlServiceImpl
implements BdcZdGlService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BdcZdGlServiceImpl.class);
    @Autowired
    private EntityMapper entityMapper;

    @Override
    public List<HashMap> getZdTableData(Class zdClass) {
        if (zdClass != null) {
            try {
                Example example = new Example(zdClass);
                List dataList = this.entityMapper.selectByExample(example);
                ArrayList<HashMap> mapList = new ArrayList<HashMap>();
                if (CollectionUtils.isNotEmpty(dataList)) {
                    for (Object data : dataList) {
                        Field[] fields;
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        for (Field field : fields = zdClass.getDeclaredFields()) {
                            field.setAccessible(true);
                            map.put(StringUtils.upperCase((String)field.getName()), field.get(data));
                        }
                        mapList.add(map);
                    }
                }
                return mapList;
            }
            catch (IllegalAccessException ex) {
                LOGGER.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return new ArrayList<HashMap>(0);
    }

    @Override
    public int saveBdcZdTable(Object zd) {
        if (zd == null) {
            throw new AppException("\u4fdd\u5b58\u7684\u5b57\u5178\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return this.entityMapper.insertSelective(zd);
    }
}

