/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.common.core.service.Impl;

import cn.gtmap.realestate.common.core.dao.BdcConfigMapper;
import cn.gtmap.realestate.common.core.domain.BdcDysjPzDO;
import cn.gtmap.realestate.common.core.domain.BdcDysjZbPzDO;
import cn.gtmap.realestate.common.core.enums.BdcDyBeanEnum;
import cn.gtmap.realestate.common.core.enums.BdcDySjlyEnum;
import cn.gtmap.realestate.common.core.ex.AppException;
import cn.gtmap.realestate.common.core.ex.MissingArgumentException;
import cn.gtmap.realestate.common.core.service.BdcDyConfigService;
import cn.gtmap.realestate.common.core.service.BdcDysjPzService;
import cn.gtmap.realestate.common.util.BeansResolveUtils;
import cn.gtmap.realestate.common.util.RestRpcUtils;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BdcDysjPzServiceImpl
implements BdcDysjPzService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BdcDysjPzServiceImpl.class);
    private final Pattern pattern = Pattern.compile("\\$\\{[a-zA-Z]+\\}");
    @Autowired
    BeansResolveUtils beansResolveUtils;
    @Autowired
    RestRpcUtils restRpcUtils;

    @Override
    public Map queryPrintDatasList(Map configParam, String configBeanName, List<BdcDysjPzDO> bdcDysjPzDOList) {
        if (StringUtils.isBlank((CharSequence)configBeanName)) {
            throw new AppException("\u6267\u884c\u914d\u7f6esql\u7684bean\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(bdcDysjPzDOList)) {
            throw new AppException("\u6253\u5370\u4e3b\u8868\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList dataList = Lists.newArrayList();
        bdcDysjPzDOList.forEach(data -> {
            ArrayList csList = Lists.newArrayList((Object[])data.getCs().split(","));
            csList.forEach(cs -> {
                if (configParam.get(cs) == null) {
                    throw new MissingArgumentException("\u4ee3\u7801\u7f3a\u5931\u6253\u5370\u914d\u7f6e\u7684\u53c2\u6570:{}" + cs);
                }
            });
            if (BdcDySjlyEnum.FW.getCode().equals(data.getSjly())) {
                this.getResultByGetReuqest(data.getQqyy(), data.getDysjy(), configParam, dataList);
            } else {
                ArrayList sqlList = Lists.newArrayList((Object[])data.getDysjy().split(";"));
                sqlList.forEach(sql -> {
                    List<Map> configList;
                    try {
                        Matcher matcher = this.pattern.matcher((CharSequence)sql);
                        String matchStr = null;
                        String condition = null;
                        Object value = null;
                        while (matcher.find()) {
                            matchStr = matcher.group();
                            condition = matchStr.substring(2, matchStr.length() - 1);
                            value = configParam.get(condition);
                            if (value == null) {
                                throw new MissingArgumentException(condition);
                            }
                            sql = sql.replaceAll("\\$\\{" + condition + "\\}", value.toString());
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("\u6253\u5370\u4e3b\u8868\u66ff\u6362${param}\u7c7b\u53c2\u6570\u65f6\u53d1\u8bc1\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7814\u53d1\uff01");
                    }
                    configParam.put("sql", sql);
                    if (BdcDyBeanEnum.BdcDyConfigService.getBeanName().equals(configBeanName)) {
                        BdcDyConfigService bdcDyConfigService = (BdcDyConfigService)this.beansResolveUtils.getBeanByName(configBeanName);
                        configList = bdcDyConfigService.executeConfigSql(configParam, data.getDbsource());
                    } else {
                        BdcConfigMapper bdcConfigMapper = (BdcConfigMapper)this.beansResolveUtils.getBeanByName(configBeanName);
                        configList = bdcConfigMapper.executeConfigSql(configParam);
                    }
                    if (CollectionUtils.isNotEmpty(configList)) {
                        dataList.addAll(configList);
                    }
                });
            }
        });
        HashMap map = Maps.newHashMap();
        dataList.forEach(data -> {
            if (null != data) {
                map.putAll(data);
            }
        });
        return map;
    }

    @Override
    public Multimap queryPrintDetailList(Map configParam, String configBeanName, List<BdcDysjZbPzDO> bdcDysjZbPzDOList) {
        if (StringUtils.isBlank((CharSequence)configBeanName)) {
            throw new MissingArgumentException("\u6267\u884c\u914d\u7f6esql\u7684bean\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(bdcDysjZbPzDOList)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u6253\u5370\u5b50\u8868\u914d\u7f6e\u4e3a\u7a7a");
            }
            return ArrayListMultimap.create();
        }
        ArrayListMultimap multimap = ArrayListMultimap.create();
        bdcDysjZbPzDOList.forEach(arg_0 -> this.lambda$queryPrintDetailList$5(configParam, configBeanName, (Multimap)multimap, arg_0));
        return multimap;
    }

    private void getResultByGetReuqest(String appName, String url, Map params, List<Map> resultDataList) {
        try {
            List result = (List)this.restRpcUtils.getRpcRequest(appName, url, params);
            if (CollectionUtils.isNotEmpty((Collection)result)) {
                ArrayList newList = new ArrayList(result.size());
                result.stream().forEach(map -> {
                    HashMap newMap = new HashMap(map.size());
                    for (Map.Entry entry : map.entrySet()) {
                        newMap.put(((String)entry.getKey()).toUpperCase(), entry.getValue());
                    }
                    newList.add(newMap);
                });
                resultDataList.addAll(newList);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6253\u5370-\u670d\u52a1\u65b9\u5f0f\u83b7\u53d6\u6570\u636e\u5185\u5bb9\u53d1\u751f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new AppException("\u6253\u5370-\u670d\u52a1\u65b9\u5f0f\u83b7\u53d6\u6570\u636e\u5185\u5bb9\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
        }
    }

    private /* synthetic */ void lambda$queryPrintDetailList$5(Map configParam, String configBeanName, Multimap multimap, BdcDysjZbPzDO detail) {
        ArrayList csList = Lists.newArrayList((Object[])detail.getCs().split(","));
        csList.forEach(cs -> {
            if (configParam.get(cs) == null) {
                throw new MissingArgumentException("\u6253\u5370\u914d\u7f6e\u53c2\u6570" + cs);
            }
        });
        ArrayList sqlMapList = Lists.newArrayList();
        if (BdcDySjlyEnum.FW.getCode().equals(detail.getSjly())) {
            this.getResultByGetReuqest(detail.getQqyy(), detail.getDyzbsjy(), configParam, sqlMapList);
        } else {
            ArrayList sqlList = Lists.newArrayList((Object[])detail.getDyzbsjy().split(";"));
            int index = 1;
            HashMap sqlResult = Maps.newHashMap();
            for (String sql : sqlList) {
                List<Map> detailList;
                if (StringUtils.isBlank((CharSequence)StringUtils.trim((String)sql))) continue;
                Matcher matcher = this.pattern.matcher(sql);
                String matchStr = null;
                String condition = null;
                Object value = null;
                while (matcher.find()) {
                    matchStr = matcher.group();
                    condition = matchStr.substring(2, matchStr.length() - 1);
                    value = configParam.get(condition);
                    if (value == null) {
                        throw new MissingArgumentException(condition);
                    }
                    sql = sql.replaceAll("\\$\\{" + condition + "\\}", value.toString());
                }
                configParam.put("sql", sql);
                if (BdcDyBeanEnum.BdcDyConfigService.getBeanName().equals(configBeanName)) {
                    BdcDyConfigService bdcDyConfigService = (BdcDyConfigService)this.beansResolveUtils.getBeanByName(configBeanName);
                    detailList = bdcDyConfigService.executeConfigSql(configParam, detail.getDbsource());
                } else {
                    BdcConfigMapper bdcConfigMapper = (BdcConfigMapper)this.beansResolveUtils.getBeanByName(configBeanName);
                    detailList = bdcConfigMapper.executeConfigSql(configParam);
                }
                if (CollectionUtils.size((Object)sqlList) > 1) {
                    sqlResult.put("sql" + index, Queues.newArrayDeque(detailList));
                    ++index;
                    continue;
                }
                sqlMapList.addAll(detailList);
            }
            while (MapUtils.isNotEmpty((Map)sqlResult)) {
                Iterator iterator = sqlResult.entrySet().iterator();
                HashMap detailMap = Maps.newHashMap();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Queue queue = (Queue)entry.getValue();
                    Map map = (Map)queue.poll();
                    if (map == null) {
                        iterator.remove();
                        continue;
                    }
                    detailMap.putAll(map);
                }
                if (!MapUtils.isNotEmpty((Map)detailMap)) continue;
                sqlMapList.add(detailMap);
            }
        }
        String detailid = detail.getDyzbid();
        multimap.put((Object)detailid, (Object)sqlMapList);
    }
}

